/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.codec;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import org.geysermc.mcprotocollib.network.codec.PacketDefinition;
import org.geysermc.mcprotocollib.network.packet.PacketRegistry;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacketSerializer;
import org.geysermc.mcprotocollib.protocol.codec.PacketFactory;

public class MinecraftPacketRegistry {
    private final Int2ObjectMap<PacketDefinition<? extends MinecraftPacket>> clientboundPackets = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<PacketDefinition<? extends MinecraftPacket>> serverboundPackets = new Int2ObjectOpenHashMap();
    private int nextClientboundId = 0;
    private int nextServerboundId = 0;

    public static MinecraftPacketRegistry builder() {
        return new MinecraftPacketRegistry();
    }

    public <T extends MinecraftPacket> MinecraftPacketRegistry registerClientboundPacket(Class<T> packetClass, PacketFactory<T> factory) {
        this.clientboundPackets.put(this.nextClientboundId, new PacketDefinition<T>(this.nextClientboundId, packetClass, new MinecraftPacketSerializer<T>(factory)));
        ++this.nextClientboundId;
        return this;
    }

    public <T extends MinecraftPacket> MinecraftPacketRegistry registerServerboundPacket(Class<T> packetClass, PacketFactory<T> factory) {
        this.serverboundPackets.put(this.nextServerboundId, new PacketDefinition<T>(this.nextServerboundId, packetClass, new MinecraftPacketSerializer<T>(factory)));
        ++this.nextServerboundId;
        return this;
    }

    public PacketRegistry build() {
        PacketRegistry codec = new PacketRegistry();
        for (Int2ObjectMap.Entry entry : this.clientboundPackets.int2ObjectEntrySet()) {
            codec.registerClientbound((PacketDefinition)entry.getValue());
        }
        for (Int2ObjectMap.Entry entry : this.serverboundPackets.int2ObjectEntrySet()) {
            codec.registerServerbound((PacketDefinition)entry.getValue());
        }
        return codec;
    }
}

