/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util;

import java.util.BitSet;
import java.util.List;
import java.util.Optional;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.level.block.property.Property;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.level.block.type.SkullBlock;
import org.geysermc.geyser.level.physics.Direction;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.EntityEffectCache;
import org.geysermc.geyser.session.cache.SkullCache;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.LevelEvent;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.definitions.BlockDefinition;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.LevelEventPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.UpdateBlockPacket;
import org.geysermc.geyser.translator.collision.BlockCollision;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.AdventureModePredicate;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.ToolData;

public final class BlockUtils {
    public static float getBlockMiningProgressPerTick(GeyserSession session, Block block, GeyserItemStack itemInHand) {
        float destroySpeed = block.destroyTime();
        if (destroySpeed == -1.0f) {
            return 0.0f;
        }
        int speedMultiplier = BlockUtils.hasCorrectTool(session, block, itemInHand) ? 30 : 100;
        return BlockUtils.getPlayerDestroySpeed(session, block, itemInHand) / destroySpeed / (float)speedMultiplier;
    }

    private static boolean hasCorrectTool(GeyserSession session, Block block, GeyserItemStack stack) {
        return !block.requiresCorrectToolForDrops() || BlockUtils.isCorrectItemForDrops(session, block, stack);
    }

    private static boolean isCorrectItemForDrops(GeyserSession session, Block block, GeyserItemStack stack) {
        ToolData tool = stack.getComponent(DataComponentTypes.TOOL);
        if (tool == null) {
            return false;
        }
        for (ToolData.Rule rule : tool.getRules()) {
            if (rule.getCorrectForDrops() == null || !block.is(session, rule.getBlocks())) continue;
            return rule.getCorrectForDrops();
        }
        return false;
    }

    private static float getItemDestroySpeed(GeyserSession session, Block block, GeyserItemStack stack) {
        ToolData tool = stack.getComponent(DataComponentTypes.TOOL);
        if (tool == null) {
            return 1.0f;
        }
        for (ToolData.Rule rule : tool.getRules()) {
            if (rule.getSpeed() == null || !block.is(session, rule.getBlocks())) continue;
            return rule.getSpeed().floatValue();
        }
        return tool.getDefaultMiningSpeed();
    }

    private static float getPlayerDestroySpeed(GeyserSession session, Block block, GeyserItemStack itemInHand) {
        EntityEffectCache effectCache;
        int miningSpeedMultiplier;
        float destroySpeed = BlockUtils.getItemDestroySpeed(session, block, itemInHand);
        if (destroySpeed > 1.0f) {
            destroySpeed += (float)session.getPlayerEntity().getMiningEfficiency();
        }
        if ((miningSpeedMultiplier = BlockUtils.getMiningSpeedAmplification(effectCache = session.getEffectCache())) > 0) {
            destroySpeed *= 1.0f + (float)miningSpeedMultiplier * 0.2f;
        }
        if (effectCache.getMiningFatigue() != 0) {
            float slowdown = switch (effectCache.getMiningFatigue()) {
                case 1 -> 0.3f;
                case 2 -> 0.09f;
                case 3 -> 0.0027f;
                default -> 8.1E-4f;
            };
            destroySpeed *= slowdown;
        }
        destroySpeed *= (float)session.getPlayerEntity().getBlockBreakSpeed();
        if (session.getCollisionManager().isWaterInEyes()) {
            destroySpeed *= (float)session.getPlayerEntity().getSubmergedMiningSpeed();
        }
        if (!session.getPlayerEntity().isOnGround()) {
            destroySpeed /= 5.0f;
        }
        return destroySpeed;
    }

    private static int getMiningSpeedAmplification(EntityEffectCache cache) {
        return Math.max(cache.getHaste(), cache.getConduitPower());
    }

    public static double reciprocal(double progress) {
        return Math.ceil(1.0 / progress);
    }

    public static Vector3i getBlockPosition(Vector3i blockPos, Direction face) {
        return switch (face) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> blockPos.sub(0, 1, 0);
            case Direction.UP -> blockPos.add(0, 1, 0);
            case Direction.NORTH -> blockPos.sub(0, 0, 1);
            case Direction.SOUTH -> blockPos.add(0, 0, 1);
            case Direction.WEST -> blockPos.sub(1, 0, 0);
            case Direction.EAST -> blockPos.add(1, 0, 0);
        };
    }

    public static String getCleanIdentifier(String fullJavaIdentifier) {
        int stateIndex = fullJavaIdentifier.indexOf(91);
        if (stateIndex == -1) {
            return fullJavaIdentifier;
        }
        return fullJavaIdentifier.substring(0, stateIndex);
    }

    public static BlockCollision getCollision(int blockId) {
        return BlockRegistries.COLLISIONS.get(blockId);
    }

    public static void spawnBlockBreakParticles(GeyserSession session, Direction direction, Vector3i position, BlockState blockState) {
        LevelEventPacket levelEventPacket = new LevelEventPacket();
        switch (direction) {
            case UP: {
                levelEventPacket.setType(LevelEvent.PARTICLE_BREAK_BLOCK_UP);
                break;
            }
            case DOWN: {
                levelEventPacket.setType(LevelEvent.PARTICLE_BREAK_BLOCK_DOWN);
                break;
            }
            case NORTH: {
                levelEventPacket.setType(LevelEvent.PARTICLE_BREAK_BLOCK_NORTH);
                break;
            }
            case EAST: {
                levelEventPacket.setType(LevelEvent.PARTICLE_BREAK_BLOCK_EAST);
                break;
            }
            case SOUTH: {
                levelEventPacket.setType(LevelEvent.PARTICLE_BREAK_BLOCK_SOUTH);
                break;
            }
            case WEST: {
                levelEventPacket.setType(LevelEvent.PARTICLE_BREAK_BLOCK_WEST);
            }
        }
        levelEventPacket.setPosition(position.toFloat());
        levelEventPacket.setData(session.getBlockMappings().getBedrockBlock(blockState).getRuntimeId());
        session.sendUpstreamPacket(levelEventPacket);
    }

    public static void sendBedrockStopBlockBreak(GeyserSession session, Vector3f vector) {
        LevelEventPacket stopBreak = new LevelEventPacket();
        stopBreak.setType(LevelEvent.BLOCK_STOP_BREAK);
        stopBreak.setPosition(vector);
        stopBreak.setData(0);
        session.sendUpstreamPacket(stopBreak);
    }

    public static void sendBedrockBlockDestroy(GeyserSession session, Vector3f vector, int blockState) {
        LevelEventPacket blockBreakPacket = new LevelEventPacket();
        blockBreakPacket.setType(LevelEvent.PARTICLE_DESTROY_BLOCK);
        blockBreakPacket.setPosition(vector);
        blockBreakPacket.setData(session.getBlockMappings().getBedrockBlockId(blockState));
        session.sendUpstreamPacket(blockBreakPacket);
    }

    public static void restoreCorrectBlock(GeyserSession session, Vector3i vector, BlockState blockState) {
        SkullCache.Skull skull;
        SkullBlock skullBlock;
        BlockDefinition bedrockBlock = session.getBlockMappings().getBedrockBlock(blockState);
        Block block = blockState.block();
        if (block instanceof SkullBlock && (skullBlock = (SkullBlock)block).skullType() == SkullBlock.Type.PLAYER && (skull = session.getSkullCache().getSkulls().get(vector)) != null && skull.getBlockDefinition() != null) {
            bedrockBlock = skull.getBlockDefinition();
        }
        UpdateBlockPacket updateBlockPacket = new UpdateBlockPacket();
        updateBlockPacket.setDataLayer(0);
        updateBlockPacket.setBlockPosition(vector);
        updateBlockPacket.setDefinition(bedrockBlock);
        updateBlockPacket.getFlags().addAll(UpdateBlockPacket.FLAG_ALL_PRIORITY);
        session.sendUpstreamPacket(updateBlockPacket);
        UpdateBlockPacket updateWaterPacket = new UpdateBlockPacket();
        updateWaterPacket.setDataLayer(1);
        updateWaterPacket.setBlockPosition(vector);
        updateWaterPacket.setDefinition(((BitSet)BlockRegistries.WATERLOGGED.get()).get(blockState.javaId()) ? session.getBlockMappings().getBedrockWater() : session.getBlockMappings().getBedrockAir());
        updateWaterPacket.getFlags().addAll(UpdateBlockPacket.FLAG_ALL_PRIORITY);
        session.sendUpstreamPacket(updateWaterPacket);
        session.getPlayerInventoryHolder().updateSlot(session.getPlayerInventory().getHeldItemSlot());
    }

    public static void restoreCorrectBlock(GeyserSession session, Vector3i blockPos) {
        BlockUtils.restoreCorrectBlock(session, blockPos, session.getGeyser().getWorldManager().blockAt(session, blockPos));
    }

    public static void stopBreakAndRestoreBlock(GeyserSession session, Vector3i vector, BlockState blockState) {
        BlockUtils.sendBedrockStopBlockBreak(session, vector.toFloat());
        BlockUtils.restoreCorrectBlock(session, vector, blockState);
    }

    public static boolean blockMatchesPredicate(GeyserSession session, BlockState state, AdventureModePredicate.BlockPredicate predicate) {
        List<AdventureModePredicate.PropertyMatcher> matchers;
        if (predicate.getBlocks() != null && !state.block().is(session, predicate.getBlocks())) {
            return false;
        }
        if (predicate.getProperties() != null && !(matchers = predicate.getProperties()).isEmpty()) {
            for (AdventureModePredicate.PropertyMatcher matcher : matchers) {
                for (Property<?> property : state.block().propertyKeys()) {
                    if (!matcher.getName().equals(property.name()) || BlockUtils.propertyMatchesPredicate(state, property, matcher)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static <T extends Comparable<T>> boolean propertyMatchesPredicate(BlockState state, Property<T> property, AdventureModePredicate.PropertyMatcher matcher) {
        Optional<T> max;
        Optional<T> min;
        Comparable stateValue = state.getValue(property);
        if (matcher.getValue() != null) {
            Optional<T> value = property.valueOf(matcher.getValue());
            return value.isPresent() && stateValue.equals(value.get());
        }
        if (matcher.getMinValue() != null && ((min = property.valueOf(matcher.getMinValue())).isEmpty() || stateValue.compareTo((Comparable)((Comparable)min.get())) < 0)) {
            return false;
        }
        return matcher.getMaxValue() == null || !(max = property.valueOf(matcher.getMaxValue())).isEmpty() && stateValue.compareTo((Comparable)((Comparable)max.get())) <= 0;
    }

    private BlockUtils() {
    }
}

