/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock.world;

import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.SoundEvent;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.LevelSoundEventPacket;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.CooldownUtils;
import org.geysermc.mcprotocollib.protocol.data.game.entity.object.Direction;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundUseItemOnPacket;

@Translator(packet=LevelSoundEventPacket.class)
public class BedrockLevelSoundEventTranslator
extends PacketTranslator<LevelSoundEventPacket> {
    @Override
    public void translate(GeyserSession session, LevelSoundEventPacket packet) {
        session.sendUpstreamPacket(packet);
        if (packet.getSound() == SoundEvent.ATTACK_NODAMAGE || packet.getSound() == SoundEvent.ATTACK || packet.getSound() == SoundEvent.ATTACK_STRONG) {
            CooldownUtils.sendCooldown(session);
        }
        if (packet.getSound() == SoundEvent.HIT) {
            Vector3f position = packet.getPosition();
            Vector3i blockPosition = Vector3i.from((double)position.getX(), (double)position.getY(), (double)position.getZ());
            BlockState potentialLectern = session.getGeyser().getWorldManager().blockAt(session, blockPosition);
            if (potentialLectern.getValue(Properties.HAS_BOOK, false).booleanValue()) {
                session.setDroppingLecternBook(true);
                ServerboundUseItemOnPacket blockPacket = new ServerboundUseItemOnPacket(blockPosition, Direction.DOWN, Hand.MAIN_HAND, 0.0f, 0.0f, 0.0f, false, false, session.getWorldCache().nextPredictionSequence());
                session.sendDownstreamGamePacket(blockPacket);
            }
        }
    }
}

