/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock.entity.player.input;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cloudburstmc.math.GenericMath;
import org.cloudburstmc.math.vector.Vector2f;
import org.cloudburstmc.math.vector.Vector3d;
import org.cloudburstmc.math.vector.Vector3f;
import org.geysermc.geyser.entity.type.BoatEntity;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.living.animal.horse.AbstractHorseEntity;
import org.geysermc.geyser.entity.type.living.animal.horse.LlamaEntity;
import org.geysermc.geyser.entity.type.living.animal.nautilus.AbstractNautilusEntity;
import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.geyser.entity.vehicle.ClientVehicle;
import org.geysermc.geyser.entity.vehicle.HorseVehicleComponent;
import org.geysermc.geyser.entity.vehicle.VehicleComponent;
import org.geysermc.geyser.level.physics.BoundingBox;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.InputInteractionModel;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.InputMode;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.PlayerAuthInputData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.transaction.ItemUseTransaction;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.AnimatePacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.PlayerAuthInputPacket;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.translator.protocol.bedrock.entity.player.input.BedrockMovePlayer;
import org.geysermc.geyser.util.CooldownUtils;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.Pose;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.GameMode;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.PlayerState;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.ServerboundClientTickEndPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.level.ServerboundMoveVehiclePacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundPlayerAbilitiesPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundPlayerCommandPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundSwingPacket;

@Translator(packet=PlayerAuthInputPacket.class)
public final class BedrockPlayerAuthInputTranslator
extends PacketTranslator<PlayerAuthInputPacket> {
    @Override
    public void translate(GeyserSession session, PlayerAuthInputPacket packet) {
        SessionPlayerEntity entity = session.getPlayerEntity();
        session.setClientTicks(packet.getTick());
        session.setInClientPredictedVehicle(packet.getInputData().contains((Object)PlayerAuthInputData.IN_CLIENT_PREDICTED_IN_VEHICLE) && entity.getVehicle() != null);
        boolean wasJumping = session.getInputCache().wasJumping();
        session.getInputCache().processInputs(entity, packet);
        session.getBlockBreakHandler().handlePlayerAuthInputPacket(packet);
        ServerboundPlayerCommandPacket sprintPacket = null;
        Set<PlayerAuthInputData> inputData = packet.getInputData();
        HashSet<PlayerAuthInputData> leftOverInputData = new HashSet<PlayerAuthInputData>(packet.getInputData());
        for (PlayerAuthInputData input : inputData) {
            leftOverInputData.remove((Object)input);
            switch (input) {
                case PERFORM_ITEM_INTERACTION: {
                    BedrockPlayerAuthInputTranslator.processItemUseTransaction(session, packet.getItemUseTransaction());
                    break;
                }
                case PERFORM_ITEM_STACK_REQUEST: {
                    session.getPlayerInventoryHolder().translateRequests(List.of(packet.getItemStackRequest()));
                    break;
                }
                case START_SWIMMING: {
                    entity.setFlag(EntityFlag.SWIMMING, true);
                    break;
                }
                case STOP_SWIMMING: {
                    entity.setFlag(EntityFlag.SWIMMING, false);
                    break;
                }
                case START_CRAWLING: {
                    entity.setFlag(EntityFlag.CRAWLING, true);
                    break;
                }
                case STOP_CRAWLING: {
                    entity.setFlag(EntityFlag.CRAWLING, false);
                    break;
                }
                case START_SPRINTING: {
                    if (leftOverInputData.contains((Object)PlayerAuthInputData.STOP_SPRINTING) || session.isSprinting()) break;
                    sprintPacket = new ServerboundPlayerCommandPacket(entity.javaId(), PlayerState.START_SPRINTING);
                    session.setSprinting(true);
                    break;
                }
                case STOP_SPRINTING: {
                    if (leftOverInputData.contains((Object)PlayerAuthInputData.START_SPRINTING) || !session.isSprinting()) break;
                    sprintPacket = new ServerboundPlayerCommandPacket(entity.javaId(), PlayerState.STOP_SPRINTING);
                    session.setSprinting(false);
                    break;
                }
                case START_FLYING: {
                    if (session.isCanFly()) {
                        if (session.getGameMode() == GameMode.SPECTATOR) {
                            session.sendAdventureSettings();
                            break;
                        }
                        if (session.getPlayerEntity().getFlag(EntityFlag.SWIMMING) && session.getCollisionManager().isPlayerInWater()) {
                            session.sendAdventureSettings();
                            break;
                        }
                        session.setFlying(true);
                        session.sendDownstreamGamePacket(new ServerboundPlayerAbilitiesPacket(true));
                        break;
                    }
                    session.setFlying(false);
                    session.sendAdventureSettings();
                    break;
                }
                case STOP_FLYING: {
                    session.setFlying(false);
                    session.sendDownstreamGamePacket(new ServerboundPlayerAbilitiesPacket(false));
                    break;
                }
                case START_GLIDING: {
                    if (leftOverInputData.contains((Object)PlayerAuthInputData.STOP_GLIDING)) break;
                    if (entity.canStartGliding()) {
                        if (session.isFlying()) {
                            session.setFlying(false);
                            session.sendDownstreamGamePacket(new ServerboundPlayerAbilitiesPacket(false));
                        }
                        entity.setFlag(EntityFlag.GLIDING, true);
                        session.sendDownstreamGamePacket(new ServerboundPlayerCommandPacket(entity.getEntityId(), PlayerState.START_ELYTRA_FLYING));
                        break;
                    }
                    entity.forceFlagUpdate();
                    entity.setFlag(EntityFlag.GLIDING, false);
                    if (!session.isFlying()) break;
                    session.sendAdventureSettings();
                    break;
                }
                case START_SPIN_ATTACK: {
                    entity.setFlag(EntityFlag.DAMAGE_NEARBY_MOBS, true);
                    break;
                }
                case STOP_SPIN_ATTACK: {
                    entity.setFlag(EntityFlag.DAMAGE_NEARBY_MOBS, false);
                    break;
                }
                case STOP_GLIDING: {
                    boolean shouldBeGliding = entity.isGliding() && entity.canStartGliding();
                    entity.forceFlagUpdate();
                    entity.setFlag(EntityFlag.GLIDING, shouldBeGliding);
                    break;
                }
                case MISSED_SWING: {
                    session.setLastAirHitTick(session.getTicks());
                    if (session.getArmAnimationTicks() != 0 && session.getArmAnimationTicks() != 1) {
                        session.sendDownstreamGamePacket(new ServerboundSwingPacket(Hand.MAIN_HAND));
                        session.activateArmAnimationTicking();
                    }
                    if (packet.getInputMode().equals((Object)InputMode.TOUCH)) {
                        AnimatePacket animatePacket = new AnimatePacket();
                        animatePacket.setAction(AnimatePacket.Action.SWING_ARM);
                        animatePacket.setRuntimeEntityId(session.getPlayerEntity().getGeyserId());
                        session.sendUpstreamPacket(animatePacket);
                    }
                    CooldownUtils.sendCooldown(session);
                }
            }
        }
        Pose pose = entity.getDesiredPose();
        if (pose != session.getPose()) {
            session.setPose(pose);
            entity.setDimensionsFromPose(session.getPose());
            entity.updateBedrockMetadata();
        }
        BedrockPlayerAuthInputTranslator.processVehicleInput(session, packet, wasJumping);
        if (sprintPacket != null) {
            session.sendDownstreamGamePacket(sprintPacket);
        }
        BedrockMovePlayer.translate(session, packet);
        if (session.isSpawned()) {
            session.sendDownstreamGamePacket(ServerboundClientTickEndPacket.INSTANCE);
        }
        if (entity.getVehicle() instanceof BoatEntity && session.isInClientPredictedVehicle()) {
            boolean up = inputData.contains((Object)PlayerAuthInputData.UP);
            session.setSteeringLeft(up || inputData.contains((Object)PlayerAuthInputData.PADDLE_RIGHT));
            session.setSteeringRight(up || inputData.contains((Object)PlayerAuthInputData.PADDLE_LEFT));
        }
    }

    private static void processItemUseTransaction(GeyserSession session, ItemUseTransaction transaction) {
        if (transaction.getActionType() == 2) {
            session.setLastBlockPlaced(null);
            session.setLastBlockPlacePosition(null);
        } else {
            session.getGeyser().getLogger().error("Unhandled item use transaction type!");
            if (session.getGeyser().getLogger().isDebug()) {
                session.getGeyser().getLogger().debug(transaction);
            }
        }
    }

    private static void processVehicleInput(GeyserSession session, PlayerAuthInputPacket packet, boolean wasJumping) {
        Entity vehicle = session.getPlayerEntity().getVehicle();
        if (vehicle == null) {
            return;
        }
        boolean inClientPredictedVehicle = packet.getInputData().contains((Object)PlayerAuthInputData.IN_CLIENT_PREDICTED_IN_VEHICLE);
        if (vehicle instanceof ClientVehicle) {
            boolean isMobileAndClassicMovement;
            boolean bl = isMobileAndClassicMovement = packet.getInputMode() == InputMode.TOUCH && packet.getInputInteractionModel() == InputInteractionModel.CLASSIC;
            if (isMobileAndClassicMovement && vehicle instanceof BoatEntity) {
                boolean left = packet.getInputData().contains((Object)PlayerAuthInputData.PADDLE_LEFT);
                boolean right = packet.getInputData().contains((Object)PlayerAuthInputData.PADDLE_RIGHT);
                if (left && right) {
                    session.getPlayerEntity().setVehicleInput(Vector2f.UNIT_Y);
                } else {
                    session.getPlayerEntity().setVehicleInput(Vector2f.UNIT_X.mul(left ? 1.0f : (right ? -1.0f : 0.0f)));
                }
            } else {
                session.getPlayerEntity().setVehicleInput(packet.getMotion());
            }
        }
        boolean sendMovement = false;
        if (vehicle instanceof AbstractHorseEntity && !(vehicle instanceof LlamaEntity)) {
            sendMovement = inClientPredictedVehicle;
        } else if (vehicle instanceof BoatEntity) {
            boolean bl = sendMovement = inClientPredictedVehicle && (vehicle.getPassengers().size() == 1 || session.getPlayerEntity().isRidingInFront());
        }
        if ((vehicle instanceof AbstractHorseEntity || vehicle instanceof AbstractNautilusEntity) && !vehicle.getFlag(EntityFlag.HAS_DASH_COOLDOWN)) {
            int currentJumpingTicks = session.getInputCache().getJumpingTicks();
            if (currentJumpingTicks < 0) {
                session.getInputCache().setJumpingTicks(++currentJumpingTicks);
                if (currentJumpingTicks == 0) {
                    session.getInputCache().setJumpScale(0.0f);
                }
            }
            boolean holdingJump = packet.getInputData().contains((Object)PlayerAuthInputData.JUMPING);
            if (wasJumping && !holdingJump) {
                AbstractHorseEntity horse;
                VehicleComponent<?> vehicleComponent;
                int finalVehicleJumpStrength = GenericMath.floor((float)(session.getInputCache().getJumpScale() * 100.0f));
                session.sendDownstreamGamePacket(new ServerboundPlayerCommandPacket(session.getPlayerEntity().getEntityId(), PlayerState.START_HORSE_JUMP, finalVehicleJumpStrength));
                session.getInputCache().setJumpingTicks(-10);
                session.getPlayerEntity().setVehicleJumpStrength(finalVehicleJumpStrength);
                if (vehicle instanceof AbstractHorseEntity && (vehicleComponent = (horse = (AbstractHorseEntity)vehicle).getVehicleComponent()) instanceof HorseVehicleComponent) {
                    HorseVehicleComponent horseVehicleComponent = (HorseVehicleComponent)vehicleComponent;
                    horseVehicleComponent.setAllowStandSliding(true);
                }
            } else if (!wasJumping && holdingJump) {
                session.getInputCache().setJumpingTicks(0);
                session.getInputCache().setJumpScale(0.0f);
            } else if (holdingJump) {
                session.getInputCache().setJumpingTicks(++currentJumpingTicks);
                if (currentJumpingTicks < 10) {
                    session.getInputCache().setJumpScale((float)session.getInputCache().getJumpingTicks() * 0.1f);
                } else {
                    session.getInputCache().setJumpScale(0.8f + 2.0f / (float)(currentJumpingTicks - 9) * 0.1f);
                }
            }
        } else {
            session.getInputCache().setJumpScale(0.0f);
        }
        if (sendMovement) {
            Vector3f position = vehicle.getPosition();
            BoundingBox box = new BoundingBox(position.down(vehicle instanceof BoatEntity ? vehicle.getDefinition().offset() : 0.0f).up(vehicle.getBoundingBoxHeight() / 2.0f).toDouble(), vehicle.getBoundingBoxWidth(), vehicle.getBoundingBoxHeight(), vehicle.getBoundingBoxWidth());
            Vector3d movement = session.getPlayerEntity().getLastTickEndVelocity().toDouble();
            Vector3d correctedMovement = session.getCollisionManager().correctMovementForCollisions(movement, box, true, false);
            vehicle.setOnGround(correctedMovement.getY() != movement.getY() && session.getPlayerEntity().getLastTickEndVelocity().getY() < 0.0f);
            Vector3f vehiclePosition = packet.getPosition();
            Vector2f vehicleRotation = packet.getVehicleRotation();
            if (vehicleRotation == null) {
                return;
            }
            if (session.getWorldBorder().isPassingIntoBorderBoundaries(vehiclePosition, false)) {
                if (vehicle instanceof BoatEntity) {
                    BoatEntity boat = (BoatEntity)vehicle;
                    boat.moveAbsoluteWithoutAdjustments(position, vehicle.getYaw(), vehicle.isOnGround(), true);
                } else {
                    vehicle.moveAbsolute(position, vehicle.getYaw(), vehicle.getPitch(), vehicle.getHeadYaw(), vehicle.isOnGround(), true);
                }
                return;
            }
            if (vehicle instanceof BoatEntity) {
                vehiclePosition = vehiclePosition.down(vehicle.getDefinition().offset());
            }
            vehicle.setPosition(vehiclePosition);
            ServerboundMoveVehiclePacket moveVehiclePacket = new ServerboundMoveVehiclePacket(vehiclePosition.toDouble(), vehicle instanceof BoatEntity ? vehicleRotation.getY() - 90.0f : vehicleRotation.getY(), vehiclePosition.getX(), vehicle.isOnGround());
            session.sendDownstreamGamePacket(moveVehiclePacket);
        }
    }
}

