/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.command;

import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.common.util.Preconditions;

public final class CommandSymbolData {
    private static final int ARG_FLAG_VALID = 0x100000;
    private static final int ARG_FLAG_ENUM = 0x200000;
    private static final int ARG_FLAG_POSTFIX = 0x1000000;
    private static final int ARG_FLAG_SOFT_ENUM = 0x4000000;
    private final int value;
    private final boolean commandEnum;
    private final boolean softEnum;
    private final boolean postfix;

    public static CommandSymbolData deserialize(int type) {
        int value = type & 0xFFFF;
        boolean commandEnum = (type & 0x200000) != 0;
        boolean softEnum = (type & 0x4000000) != 0;
        boolean postfix = (type & 0x1000000) != 0;
        Preconditions.checkArgument(postfix || (type & 0x100000) != 0, "Invalid command param type: " + type);
        return new CommandSymbolData(value, commandEnum, softEnum, postfix);
    }

    public int serialize() {
        int value = this.value;
        if (this.commandEnum) {
            value |= 0x200000;
        }
        if (this.softEnum) {
            value |= 0x4000000;
        }
        value = this.postfix ? (value |= 0x1000000) : (value |= 0x100000);
        return value;
    }

    public CommandSymbolData(int value, boolean commandEnum, boolean softEnum, boolean postfix) {
        this.value = value;
        this.commandEnum = commandEnum;
        this.softEnum = softEnum;
        this.postfix = postfix;
    }

    public int getValue() {
        return this.value;
    }

    public boolean isCommandEnum() {
        return this.commandEnum;
    }

    public boolean isSoftEnum() {
        return this.softEnum;
    }

    public boolean isPostfix() {
        return this.postfix;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommandSymbolData)) {
            return false;
        }
        CommandSymbolData other = (CommandSymbolData)o;
        if (this.getValue() != other.getValue()) {
            return false;
        }
        if (this.isCommandEnum() != other.isCommandEnum()) {
            return false;
        }
        if (this.isSoftEnum() != other.isSoftEnum()) {
            return false;
        }
        return this.isPostfix() == other.isPostfix();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getValue();
        result = result * 59 + (this.isCommandEnum() ? 79 : 97);
        result = result * 59 + (this.isSoftEnum() ? 79 : 97);
        result = result * 59 + (this.isPostfix() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "CommandSymbolData(value=" + this.getValue() + ", commandEnum=" + this.isCommandEnum() + ", softEnum=" + this.isSoftEnum() + ", postfix=" + this.isPostfix() + ")";
    }
}

