/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.v618.serializer;

import io.netty.buffer.ByteBuf;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.HashMap;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.BedrockCodecHelper;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.v448.serializer.ResourcePacksInfoSerializer_v448;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.ResourcePacksInfoPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.common.util.Preconditions;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.common.util.VarInts;

public class ResourcePacksInfoSerializer_v618
extends ResourcePacksInfoSerializer_v448 {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(ResourcePacksInfoSerializer_v618.class);
    public static final ResourcePacksInfoSerializer_v618 INSTANCE = new ResourcePacksInfoSerializer_v618();

    @Override
    public void serialize(ByteBuf buffer, BedrockCodecHelper helper, ResourcePacksInfoPacket packet) {
        super.serialize(buffer, helper, packet);
        this.writeCDNEntries(buffer, packet, helper);
    }

    @Override
    public void deserialize(ByteBuf buffer, BedrockCodecHelper helper, ResourcePacksInfoPacket packet) {
        super.deserialize(buffer, helper, packet);
        this.readCDNEntries(buffer, packet, helper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeCDNEntries(ByteBuf buffer, ResourcePacksInfoPacket packet, BedrockCodecHelper helper) {
        ByteBuf byteBuf = buffer.alloc().ioBuffer();
        try {
            int size = 0;
            for (ResourcePacksInfoPacket.Entry info : packet.getResourcePackInfos()) {
                if (info.getCdnUrl() == null) continue;
                helper.writeString(byteBuf, info.getPackId() + "_" + info.getPackVersion());
                helper.writeString(byteBuf, info.getCdnUrl());
                ++size;
            }
            VarInts.writeUnsignedInt(buffer, size);
            if (size > 0) {
                buffer.writeBytes(byteBuf);
            }
        }
        finally {
            byteBuf.release();
        }
    }

    protected void readCDNEntries(ByteBuf buffer, ResourcePacksInfoPacket packet, BedrockCodecHelper helper) {
        String url;
        int size = VarInts.readUnsignedInt(buffer);
        Preconditions.checkArgument(helper.getEncodingSettings().maxListSize() <= 0 || size <= helper.getEncodingSettings().maxListSize(), "CDN entries size is too big: %s", size);
        if (size == 0 || packet.getResourcePackInfos().isEmpty()) {
            return;
        }
        HashMap<String, String> cdnUrls = new HashMap<String, String>();
        for (int i = 0; i < size; ++i) {
            String idVersion = helper.readString(buffer);
            url = helper.readString(buffer);
            cdnUrls.put(idVersion, url);
        }
        for (ResourcePacksInfoPacket.Entry info : packet.getResourcePackInfos()) {
            url = (String)cdnUrls.remove(info.getPackId() + "_" + info.getPackVersion());
            if (url == null) continue;
            info.setCdnUrl(url);
        }
        if (log.isDebugEnabled() && !cdnUrls.isEmpty()) {
            log.debug("Found {} CDN URLs that do not match any resource pack", (Object)cdnUrls.size());
        }
    }

    protected ResourcePacksInfoSerializer_v618() {
    }
}

