/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.cache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.PlayerInventory;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.tags.ItemTag;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.ContainerSlotType;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.FullContainerName;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.ContainerRegistryCleanupPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.InventoryContentPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.InventorySlotPacket;
import org.geysermc.geyser.util.InventoryUtils;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;

public final class BundleCache {
    private static final int BUNDLE_CONTAINER_ID = 125;
    private final GeyserSession session;
    private int nextBundleId;
    private int releaseTick = -1;

    public BundleCache(GeyserSession session) {
        this.session = session;
    }

    public void initialize(GeyserItemStack itemStack) {
        if (itemStack.is(this.session, ItemTag.BUNDLES)) {
            List<ItemStack> rawContents;
            if (itemStack.getBundleData() != null) {
                this.session.getGeyser().getLogger().warning("Stack has bundle data already! It should not!");
                if (this.session.getGeyser().getLogger().isDebug()) {
                    this.session.getGeyser().getLogger().debug("Player: " + this.session.javaUsername());
                    this.session.getGeyser().getLogger().debug("Stack: " + String.valueOf(itemStack));
                }
            }
            BundleData bundleData = (rawContents = itemStack.getComponent(DataComponentTypes.BUNDLE_CONTENTS)) != null ? new BundleData(this.session, rawContents) : new BundleData();
            itemStack.setBundleData(bundleData);
        }
    }

    public void markNewBundle(@Nullable BundleData bundleData) {
        if (bundleData == null) {
            return;
        }
        if (bundleData.bundleId != -1) {
            return;
        }
        bundleData.bundleId = this.nextBundleId++;
        for (GeyserItemStack stack : bundleData.contents()) {
            stack.setNetId(this.session.getNextItemNetId());
            this.session.getBundleCache().markNewBundle(stack.getBundleData());
        }
    }

    public ItemData checkForBundle(GeyserItemStack itemStack, ItemData.Builder itemData) {
        NbtMap nbt;
        if (itemStack.getBundleData() == null) {
            return itemData.build();
        }
        List<GeyserItemStack> contents = itemStack.getBundleData().contents();
        int containerId = itemStack.getBundleId();
        if (containerId == -1) {
            this.session.getGeyser().getLogger().warning("Bundle ID should not be -1!");
        }
        NbtMapBuilder builder = (nbt = itemData.build().getTag()) == null ? NbtMap.builder() : nbt.toBuilder();
        builder.putInt("bundle_id", containerId);
        itemData.tag(builder.build());
        ItemData finalItem = itemData.build();
        if (!itemStack.getBundleData().triggerFullContentsUpdate) {
            return finalItem;
        }
        Object[] array = new ItemData[64];
        Arrays.fill(array, ItemData.AIR);
        List<Object> bedrockItems = Arrays.asList(array);
        int j = 0;
        for (int i = contents.size() - 1; i >= 0; --i) {
            bedrockItems.set(j++, contents.get(i).getItemData(this.session));
        }
        InventoryContentPacket packet = new InventoryContentPacket();
        packet.setContainerId(125);
        packet.setContents(bedrockItems);
        packet.setContainerNameData(BundleCache.createContainer(containerId));
        packet.setStorageItem(finalItem);
        this.session.sendUpstreamPacket(packet);
        return finalItem;
    }

    public void onItemAdded(GeyserItemStack bundle) {
        BundleData data = bundle.getBundleData();
        data.freshFromServer = false;
        data.triggerFullContentsUpdate = false;
        List<GeyserItemStack> contents = data.contents();
        int bedrockSlot = BundleCache.platformConvertSlot(contents.size(), 0);
        ItemData bedrockContent = contents.get(0).getItemData(this.session);
        this.sendInventoryPacket(data.bundleId(), bedrockSlot, bedrockContent, bundle.getItemData(this.session));
        data.triggerFullContentsUpdate = true;
    }

    public void onItemRemoved(GeyserItemStack bundle, int slot) {
        BundleData data = bundle.getBundleData();
        data.freshFromServer = false;
        data.triggerFullContentsUpdate = false;
        List<GeyserItemStack> contents = data.contents();
        ItemData baseBundle = bundle.getItemData(this.session);
        this.sendInventoryPacket(data.bundleId(), BundleCache.platformConvertSlot(contents.size() + 1, 0), ItemData.AIR, baseBundle);
        for (int i = 0; i < slot; ++i) {
            this.sendInventoryPacket(data.bundleId(), BundleCache.platformConvertSlot(contents.size(), i), contents.get(i).getItemData(this.session), baseBundle);
        }
        data.triggerFullContentsUpdate = true;
    }

    private void sendInventoryPacket(int bundleId, int bedrockSlot, ItemData bedrockContent, ItemData baseBundle) {
        InventorySlotPacket packet = new InventorySlotPacket();
        packet.setContainerId(125);
        packet.setItem(bedrockContent);
        packet.setSlot(bedrockSlot);
        packet.setContainerNameData(BundleCache.createContainer(bundleId));
        packet.setStorageItem(baseBundle);
        this.session.sendUpstreamPacket(packet);
    }

    public void onOldItemDelete(GeyserItemStack itemStack) {
        if (itemStack.getBundleId() != -1) {
            ContainerRegistryCleanupPacket packet = new ContainerRegistryCleanupPacket();
            packet.getContainers().add(BundleCache.createContainer(itemStack.getBundleId()));
            this.session.sendUpstreamPacket(packet);
        }
    }

    public void onInventoryClose(Inventory inventory) {
        if (inventory instanceof PlayerInventory) {
            return;
        }
        for (int i = 0; i < inventory.getSize(); ++i) {
            GeyserItemStack item = inventory.getItem(i);
            this.onOldItemDelete(item);
        }
    }

    public void awaitRelease() {
        if (this.session.getPlayerInventory().getItemInHand().is(this.session, ItemTag.BUNDLES)) {
            this.releaseTick = this.session.getTicks() + 1;
        }
    }

    public void markRelease() {
        this.releaseTick = -1;
    }

    public void tick() {
        if (this.releaseTick != -1 && this.session.getTicks() >= this.releaseTick) {
            this.session.releaseItem();
            this.markRelease();
        }
    }

    public static int platformConvertSlot(int contentsSize, int rawSlot) {
        return contentsSize - rawSlot - 1;
    }

    public static FullContainerName createContainer(int id) {
        return new FullContainerName(ContainerSlotType.DYNAMIC_CONTAINER, id);
    }

    public static final class BundleData {
        private final List<GeyserItemStack> contents = new ArrayList<GeyserItemStack>();
        private int bundleId = -1;
        private boolean triggerFullContentsUpdate = true;
        private boolean freshFromServer = true;

        BundleData(GeyserSession session, List<ItemStack> contents) {
            this();
            for (ItemStack content : contents) {
                GeyserItemStack itemStack = GeyserItemStack.from(session, content);
                session.getBundleCache().initialize(itemStack);
                this.contents.add(itemStack);
            }
        }

        BundleData() {
        }

        public int bundleId() {
            return this.bundleId;
        }

        public List<GeyserItemStack> contents() {
            return this.contents;
        }

        public boolean freshFromServer() {
            return this.freshFromServer;
        }

        public List<ItemStack> toComponent() {
            ArrayList<ItemStack> component = new ArrayList<ItemStack>(this.contents.size());
            for (GeyserItemStack content : this.contents) {
                component.add(content.getItemStack());
            }
            return component;
        }

        public void updateNetIds(GeyserSession session, BundleData oldData) {
            List<GeyserItemStack> oldContents = oldData.contents();
            int oldIndex = 0;
            for (int newIndex = 0; newIndex < this.contents.size(); ++newIndex) {
                GeyserItemStack itemStack = this.contents.get(newIndex);
                if (oldIndex >= oldContents.size()) {
                    if (!this.freshFromServer) continue;
                    Inventory.updateItemNetId(GeyserItemStack.EMPTY, itemStack, session);
                    session.getBundleCache().markNewBundle(itemStack.getBundleData());
                    continue;
                }
                GeyserItemStack oldItem = oldContents.get(oldIndex);
                if (!InventoryUtils.canStack(oldItem, itemStack)) {
                    boolean found = false;
                    if (oldIndex + 1 < oldContents.size() && InventoryUtils.canStack(oldItem = oldContents.get(oldIndex + 1), itemStack)) {
                        ++oldIndex;
                        found = true;
                    }
                    if (!found && oldIndex - 1 >= 0 && InventoryUtils.canStack(oldItem = oldContents.get(oldIndex - 1), itemStack)) {
                        --oldIndex;
                        found = true;
                    }
                    if (!found) {
                        oldItem = GeyserItemStack.EMPTY;
                    }
                }
                if (oldItem != GeyserItemStack.EMPTY || this.freshFromServer) {
                    Inventory.updateItemNetId(oldItem, itemStack, session);
                }
                ++oldIndex;
            }
            this.bundleId = oldData.bundleId();
        }

        public BundleData copy() {
            BundleData data = new BundleData();
            data.bundleId = this.bundleId;
            for (GeyserItemStack content : this.contents) {
                data.contents.add(content.copy());
            }
            data.freshFromServer = this.freshFromServer;
            return data;
        }
    }
}

