/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.type;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.nbt.NbtMap;
import org.geysermc.geyser.api.block.custom.CustomBlockState;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.registry.type.GeyserBedrockBlock;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.BlockPropertyData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.definitions.BlockDefinition;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.common.DefinitionRegistry;

public final class BlockMappings
implements DefinitionRegistry<BlockDefinition> {
    private final GeyserBedrockBlock bedrockAir;
    private final BlockDefinition bedrockWater;
    private final BlockDefinition bedrockMovingBlock;
    private final GeyserBedrockBlock[] javaToBedrockBlocks;
    private final GeyserBedrockBlock[] javaToVanillaBedrockBlocks;
    private final Int2ObjectMap<String> javaToBedrockIdentifiers;
    private final Map<NbtMap, GeyserBedrockBlock> stateDefinitionMap;
    private final GeyserBedrockBlock[] bedrockRuntimeMap;
    private final int[] remappedVanillaIds;
    private final BlockDefinition commandBlock;
    private final BlockDefinition mobSpawnerBlock;
    private final BlockDefinition netherPortalBlock;
    private final IntArrayList collisionIgnoredBlocks;
    private final Map<NbtMap, BlockDefinition> itemFrames;
    private final Map<Block, NbtMap> flowerPotBlocks;
    private final Set<BlockDefinition> jigsawStates;
    private final Map<String, BlockDefinition> structureBlockStates;
    private final List<BlockPropertyData> blockProperties;
    private final Object2ObjectMap<CustomBlockState, GeyserBedrockBlock> customBlockStateDefinitions;
    private final Int2ObjectMap<GeyserBedrockBlock> extendedCollisionBoxes;

    public int getBedrockBlockId(int javaState) {
        return this.getBedrockBlock(javaState).getRuntimeId();
    }

    public GeyserBedrockBlock getBedrockBlock(int javaState) {
        if (javaState < 0 || javaState >= this.javaToBedrockBlocks.length) {
            return this.bedrockAir;
        }
        return this.javaToBedrockBlocks[javaState];
    }

    public GeyserBedrockBlock getBedrockBlock(BlockState javaState) {
        return this.getBedrockBlock(javaState.javaId());
    }

    public GeyserBedrockBlock getVanillaBedrockBlock(BlockState javaState) {
        return this.getVanillaBedrockBlock(javaState.javaId());
    }

    public GeyserBedrockBlock getVanillaBedrockBlock(int javaState) {
        if (javaState < 0 || javaState >= this.javaToVanillaBedrockBlocks.length) {
            return this.bedrockAir;
        }
        return this.javaToVanillaBedrockBlocks[javaState];
    }

    public BlockDefinition getItemFrame(NbtMap tag) {
        return this.itemFrames.get(tag);
    }

    public boolean isItemFrame(BlockDefinition definition) {
        if (definition instanceof GeyserBedrockBlock) {
            GeyserBedrockBlock def = (GeyserBedrockBlock)definition;
            return this.itemFrames.containsKey(def.getState());
        }
        return false;
    }

    public BlockDefinition getStructureBlockFromMode(String mode) {
        return this.structureBlockStates.get(mode);
    }

    @Override
    public @Nullable GeyserBedrockBlock getDefinition(int bedrockId) {
        if (bedrockId < 0 || bedrockId >= this.bedrockRuntimeMap.length) {
            return null;
        }
        return this.bedrockRuntimeMap[bedrockId];
    }

    public @Nullable GeyserBedrockBlock getDefinition(NbtMap tag) {
        if (tag == null) {
            return null;
        }
        return this.stateDefinitionMap.get(tag);
    }

    @Override
    public boolean isRegistered(BlockDefinition bedrockBlock) {
        return this.getDefinition(bedrockBlock.getRuntimeId()) == bedrockBlock;
    }

    @Generated
    BlockMappings(GeyserBedrockBlock bedrockAir, BlockDefinition bedrockWater, BlockDefinition bedrockMovingBlock, GeyserBedrockBlock[] javaToBedrockBlocks, GeyserBedrockBlock[] javaToVanillaBedrockBlocks, Int2ObjectMap<String> javaToBedrockIdentifiers, Map<NbtMap, GeyserBedrockBlock> stateDefinitionMap, GeyserBedrockBlock[] bedrockRuntimeMap, int[] remappedVanillaIds, BlockDefinition commandBlock, BlockDefinition mobSpawnerBlock, BlockDefinition netherPortalBlock, IntArrayList collisionIgnoredBlocks, Map<NbtMap, BlockDefinition> itemFrames, Map<Block, NbtMap> flowerPotBlocks, Set<BlockDefinition> jigsawStates, Map<String, BlockDefinition> structureBlockStates, List<BlockPropertyData> blockProperties, Object2ObjectMap<CustomBlockState, GeyserBedrockBlock> customBlockStateDefinitions, Int2ObjectMap<GeyserBedrockBlock> extendedCollisionBoxes) {
        this.bedrockAir = bedrockAir;
        this.bedrockWater = bedrockWater;
        this.bedrockMovingBlock = bedrockMovingBlock;
        this.javaToBedrockBlocks = javaToBedrockBlocks;
        this.javaToVanillaBedrockBlocks = javaToVanillaBedrockBlocks;
        this.javaToBedrockIdentifiers = javaToBedrockIdentifiers;
        this.stateDefinitionMap = stateDefinitionMap;
        this.bedrockRuntimeMap = bedrockRuntimeMap;
        this.remappedVanillaIds = remappedVanillaIds;
        this.commandBlock = commandBlock;
        this.mobSpawnerBlock = mobSpawnerBlock;
        this.netherPortalBlock = netherPortalBlock;
        this.collisionIgnoredBlocks = collisionIgnoredBlocks;
        this.itemFrames = itemFrames;
        this.flowerPotBlocks = flowerPotBlocks;
        this.jigsawStates = jigsawStates;
        this.structureBlockStates = structureBlockStates;
        this.blockProperties = blockProperties;
        this.customBlockStateDefinitions = customBlockStateDefinitions;
        this.extendedCollisionBoxes = extendedCollisionBoxes;
    }

    @Generated
    public static BlockMappingsBuilder builder() {
        return new BlockMappingsBuilder();
    }

    @Generated
    public GeyserBedrockBlock getBedrockAir() {
        return this.bedrockAir;
    }

    @Generated
    public BlockDefinition getBedrockWater() {
        return this.bedrockWater;
    }

    @Generated
    public BlockDefinition getBedrockMovingBlock() {
        return this.bedrockMovingBlock;
    }

    @Generated
    public GeyserBedrockBlock[] getJavaToBedrockBlocks() {
        return this.javaToBedrockBlocks;
    }

    @Generated
    public GeyserBedrockBlock[] getJavaToVanillaBedrockBlocks() {
        return this.javaToVanillaBedrockBlocks;
    }

    @Generated
    public Int2ObjectMap<String> getJavaToBedrockIdentifiers() {
        return this.javaToBedrockIdentifiers;
    }

    @Generated
    public Map<NbtMap, GeyserBedrockBlock> getStateDefinitionMap() {
        return this.stateDefinitionMap;
    }

    @Generated
    public GeyserBedrockBlock[] getBedrockRuntimeMap() {
        return this.bedrockRuntimeMap;
    }

    @Generated
    public int[] getRemappedVanillaIds() {
        return this.remappedVanillaIds;
    }

    @Generated
    public BlockDefinition getCommandBlock() {
        return this.commandBlock;
    }

    @Generated
    public BlockDefinition getMobSpawnerBlock() {
        return this.mobSpawnerBlock;
    }

    @Generated
    public BlockDefinition getNetherPortalBlock() {
        return this.netherPortalBlock;
    }

    @Generated
    public IntArrayList getCollisionIgnoredBlocks() {
        return this.collisionIgnoredBlocks;
    }

    @Generated
    public Map<NbtMap, BlockDefinition> getItemFrames() {
        return this.itemFrames;
    }

    @Generated
    public Map<Block, NbtMap> getFlowerPotBlocks() {
        return this.flowerPotBlocks;
    }

    @Generated
    public Set<BlockDefinition> getJigsawStates() {
        return this.jigsawStates;
    }

    @Generated
    public Map<String, BlockDefinition> getStructureBlockStates() {
        return this.structureBlockStates;
    }

    @Generated
    public List<BlockPropertyData> getBlockProperties() {
        return this.blockProperties;
    }

    @Generated
    public Object2ObjectMap<CustomBlockState, GeyserBedrockBlock> getCustomBlockStateDefinitions() {
        return this.customBlockStateDefinitions;
    }

    @Generated
    public Int2ObjectMap<GeyserBedrockBlock> getExtendedCollisionBoxes() {
        return this.extendedCollisionBoxes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlockMappings)) {
            return false;
        }
        BlockMappings other = (BlockMappings)o;
        GeyserBedrockBlock this$bedrockAir = this.getBedrockAir();
        GeyserBedrockBlock other$bedrockAir = other.getBedrockAir();
        if (this$bedrockAir == null ? other$bedrockAir != null : !this$bedrockAir.equals(other$bedrockAir)) {
            return false;
        }
        BlockDefinition this$bedrockWater = this.getBedrockWater();
        BlockDefinition other$bedrockWater = other.getBedrockWater();
        if (this$bedrockWater == null ? other$bedrockWater != null : !this$bedrockWater.equals(other$bedrockWater)) {
            return false;
        }
        BlockDefinition this$bedrockMovingBlock = this.getBedrockMovingBlock();
        BlockDefinition other$bedrockMovingBlock = other.getBedrockMovingBlock();
        if (this$bedrockMovingBlock == null ? other$bedrockMovingBlock != null : !this$bedrockMovingBlock.equals(other$bedrockMovingBlock)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getJavaToBedrockBlocks(), other.getJavaToBedrockBlocks())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getJavaToVanillaBedrockBlocks(), other.getJavaToVanillaBedrockBlocks())) {
            return false;
        }
        Int2ObjectMap<String> this$javaToBedrockIdentifiers = this.getJavaToBedrockIdentifiers();
        Int2ObjectMap<String> other$javaToBedrockIdentifiers = other.getJavaToBedrockIdentifiers();
        if (this$javaToBedrockIdentifiers == null ? other$javaToBedrockIdentifiers != null : !this$javaToBedrockIdentifiers.equals(other$javaToBedrockIdentifiers)) {
            return false;
        }
        Map<NbtMap, GeyserBedrockBlock> this$stateDefinitionMap = this.getStateDefinitionMap();
        Map<NbtMap, GeyserBedrockBlock> other$stateDefinitionMap = other.getStateDefinitionMap();
        if (this$stateDefinitionMap == null ? other$stateDefinitionMap != null : !((Object)this$stateDefinitionMap).equals(other$stateDefinitionMap)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getBedrockRuntimeMap(), other.getBedrockRuntimeMap())) {
            return false;
        }
        if (!Arrays.equals(this.getRemappedVanillaIds(), other.getRemappedVanillaIds())) {
            return false;
        }
        BlockDefinition this$commandBlock = this.getCommandBlock();
        BlockDefinition other$commandBlock = other.getCommandBlock();
        if (this$commandBlock == null ? other$commandBlock != null : !this$commandBlock.equals(other$commandBlock)) {
            return false;
        }
        BlockDefinition this$mobSpawnerBlock = this.getMobSpawnerBlock();
        BlockDefinition other$mobSpawnerBlock = other.getMobSpawnerBlock();
        if (this$mobSpawnerBlock == null ? other$mobSpawnerBlock != null : !this$mobSpawnerBlock.equals(other$mobSpawnerBlock)) {
            return false;
        }
        BlockDefinition this$netherPortalBlock = this.getNetherPortalBlock();
        BlockDefinition other$netherPortalBlock = other.getNetherPortalBlock();
        if (this$netherPortalBlock == null ? other$netherPortalBlock != null : !this$netherPortalBlock.equals(other$netherPortalBlock)) {
            return false;
        }
        IntArrayList this$collisionIgnoredBlocks = this.getCollisionIgnoredBlocks();
        IntArrayList other$collisionIgnoredBlocks = other.getCollisionIgnoredBlocks();
        if (this$collisionIgnoredBlocks == null ? other$collisionIgnoredBlocks != null : !this$collisionIgnoredBlocks.equals(other$collisionIgnoredBlocks)) {
            return false;
        }
        Map<NbtMap, BlockDefinition> this$itemFrames = this.getItemFrames();
        Map<NbtMap, BlockDefinition> other$itemFrames = other.getItemFrames();
        if (this$itemFrames == null ? other$itemFrames != null : !((Object)this$itemFrames).equals(other$itemFrames)) {
            return false;
        }
        Map<Block, NbtMap> this$flowerPotBlocks = this.getFlowerPotBlocks();
        Map<Block, NbtMap> other$flowerPotBlocks = other.getFlowerPotBlocks();
        if (this$flowerPotBlocks == null ? other$flowerPotBlocks != null : !((Object)this$flowerPotBlocks).equals(other$flowerPotBlocks)) {
            return false;
        }
        Set<BlockDefinition> this$jigsawStates = this.getJigsawStates();
        Set<BlockDefinition> other$jigsawStates = other.getJigsawStates();
        if (this$jigsawStates == null ? other$jigsawStates != null : !((Object)this$jigsawStates).equals(other$jigsawStates)) {
            return false;
        }
        Map<String, BlockDefinition> this$structureBlockStates = this.getStructureBlockStates();
        Map<String, BlockDefinition> other$structureBlockStates = other.getStructureBlockStates();
        if (this$structureBlockStates == null ? other$structureBlockStates != null : !((Object)this$structureBlockStates).equals(other$structureBlockStates)) {
            return false;
        }
        List<BlockPropertyData> this$blockProperties = this.getBlockProperties();
        List<BlockPropertyData> other$blockProperties = other.getBlockProperties();
        if (this$blockProperties == null ? other$blockProperties != null : !((Object)this$blockProperties).equals(other$blockProperties)) {
            return false;
        }
        Object2ObjectMap<CustomBlockState, GeyserBedrockBlock> this$customBlockStateDefinitions = this.getCustomBlockStateDefinitions();
        Object2ObjectMap<CustomBlockState, GeyserBedrockBlock> other$customBlockStateDefinitions = other.getCustomBlockStateDefinitions();
        if (this$customBlockStateDefinitions == null ? other$customBlockStateDefinitions != null : !this$customBlockStateDefinitions.equals(other$customBlockStateDefinitions)) {
            return false;
        }
        Int2ObjectMap<GeyserBedrockBlock> this$extendedCollisionBoxes = this.getExtendedCollisionBoxes();
        Int2ObjectMap<GeyserBedrockBlock> other$extendedCollisionBoxes = other.getExtendedCollisionBoxes();
        return !(this$extendedCollisionBoxes == null ? other$extendedCollisionBoxes != null : !this$extendedCollisionBoxes.equals(other$extendedCollisionBoxes));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GeyserBedrockBlock $bedrockAir = this.getBedrockAir();
        result = result * 59 + ($bedrockAir == null ? 43 : $bedrockAir.hashCode());
        BlockDefinition $bedrockWater = this.getBedrockWater();
        result = result * 59 + ($bedrockWater == null ? 43 : $bedrockWater.hashCode());
        BlockDefinition $bedrockMovingBlock = this.getBedrockMovingBlock();
        result = result * 59 + ($bedrockMovingBlock == null ? 43 : $bedrockMovingBlock.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getJavaToBedrockBlocks());
        result = result * 59 + Arrays.deepHashCode(this.getJavaToVanillaBedrockBlocks());
        Int2ObjectMap<String> $javaToBedrockIdentifiers = this.getJavaToBedrockIdentifiers();
        result = result * 59 + ($javaToBedrockIdentifiers == null ? 43 : $javaToBedrockIdentifiers.hashCode());
        Map<NbtMap, GeyserBedrockBlock> $stateDefinitionMap = this.getStateDefinitionMap();
        result = result * 59 + ($stateDefinitionMap == null ? 43 : ((Object)$stateDefinitionMap).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getBedrockRuntimeMap());
        result = result * 59 + Arrays.hashCode(this.getRemappedVanillaIds());
        BlockDefinition $commandBlock = this.getCommandBlock();
        result = result * 59 + ($commandBlock == null ? 43 : $commandBlock.hashCode());
        BlockDefinition $mobSpawnerBlock = this.getMobSpawnerBlock();
        result = result * 59 + ($mobSpawnerBlock == null ? 43 : $mobSpawnerBlock.hashCode());
        BlockDefinition $netherPortalBlock = this.getNetherPortalBlock();
        result = result * 59 + ($netherPortalBlock == null ? 43 : $netherPortalBlock.hashCode());
        IntArrayList $collisionIgnoredBlocks = this.getCollisionIgnoredBlocks();
        result = result * 59 + ($collisionIgnoredBlocks == null ? 43 : $collisionIgnoredBlocks.hashCode());
        Map<NbtMap, BlockDefinition> $itemFrames = this.getItemFrames();
        result = result * 59 + ($itemFrames == null ? 43 : ((Object)$itemFrames).hashCode());
        Map<Block, NbtMap> $flowerPotBlocks = this.getFlowerPotBlocks();
        result = result * 59 + ($flowerPotBlocks == null ? 43 : ((Object)$flowerPotBlocks).hashCode());
        Set<BlockDefinition> $jigsawStates = this.getJigsawStates();
        result = result * 59 + ($jigsawStates == null ? 43 : ((Object)$jigsawStates).hashCode());
        Map<String, BlockDefinition> $structureBlockStates = this.getStructureBlockStates();
        result = result * 59 + ($structureBlockStates == null ? 43 : ((Object)$structureBlockStates).hashCode());
        List<BlockPropertyData> $blockProperties = this.getBlockProperties();
        result = result * 59 + ($blockProperties == null ? 43 : ((Object)$blockProperties).hashCode());
        Object2ObjectMap<CustomBlockState, GeyserBedrockBlock> $customBlockStateDefinitions = this.getCustomBlockStateDefinitions();
        result = result * 59 + ($customBlockStateDefinitions == null ? 43 : $customBlockStateDefinitions.hashCode());
        Int2ObjectMap<GeyserBedrockBlock> $extendedCollisionBoxes = this.getExtendedCollisionBoxes();
        result = result * 59 + ($extendedCollisionBoxes == null ? 43 : $extendedCollisionBoxes.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BlockMappings(bedrockAir=" + String.valueOf(this.getBedrockAir()) + ", bedrockWater=" + String.valueOf(this.getBedrockWater()) + ", bedrockMovingBlock=" + String.valueOf(this.getBedrockMovingBlock()) + ", javaToBedrockBlocks=" + Arrays.deepToString(this.getJavaToBedrockBlocks()) + ", javaToVanillaBedrockBlocks=" + Arrays.deepToString(this.getJavaToVanillaBedrockBlocks()) + ", javaToBedrockIdentifiers=" + String.valueOf(this.getJavaToBedrockIdentifiers()) + ", stateDefinitionMap=" + String.valueOf(this.getStateDefinitionMap()) + ", bedrockRuntimeMap=" + Arrays.deepToString(this.getBedrockRuntimeMap()) + ", remappedVanillaIds=" + Arrays.toString(this.getRemappedVanillaIds()) + ", commandBlock=" + String.valueOf(this.getCommandBlock()) + ", mobSpawnerBlock=" + String.valueOf(this.getMobSpawnerBlock()) + ", netherPortalBlock=" + String.valueOf(this.getNetherPortalBlock()) + ", collisionIgnoredBlocks=" + String.valueOf(this.getCollisionIgnoredBlocks()) + ", itemFrames=" + String.valueOf(this.getItemFrames()) + ", flowerPotBlocks=" + String.valueOf(this.getFlowerPotBlocks()) + ", jigsawStates=" + String.valueOf(this.getJigsawStates()) + ", structureBlockStates=" + String.valueOf(this.getStructureBlockStates()) + ", blockProperties=" + String.valueOf(this.getBlockProperties()) + ", customBlockStateDefinitions=" + String.valueOf(this.getCustomBlockStateDefinitions()) + ", extendedCollisionBoxes=" + String.valueOf(this.getExtendedCollisionBoxes()) + ")";
    }

    @Generated
    public static class BlockMappingsBuilder {
        @Generated
        private GeyserBedrockBlock bedrockAir;
        @Generated
        private BlockDefinition bedrockWater;
        @Generated
        private BlockDefinition bedrockMovingBlock;
        @Generated
        private GeyserBedrockBlock[] javaToBedrockBlocks;
        @Generated
        private GeyserBedrockBlock[] javaToVanillaBedrockBlocks;
        @Generated
        private Int2ObjectMap<String> javaToBedrockIdentifiers;
        @Generated
        private Map<NbtMap, GeyserBedrockBlock> stateDefinitionMap;
        @Generated
        private GeyserBedrockBlock[] bedrockRuntimeMap;
        @Generated
        private int[] remappedVanillaIds;
        @Generated
        private BlockDefinition commandBlock;
        @Generated
        private BlockDefinition mobSpawnerBlock;
        @Generated
        private BlockDefinition netherPortalBlock;
        @Generated
        private IntArrayList collisionIgnoredBlocks;
        @Generated
        private Map<NbtMap, BlockDefinition> itemFrames;
        @Generated
        private Map<Block, NbtMap> flowerPotBlocks;
        @Generated
        private Set<BlockDefinition> jigsawStates;
        @Generated
        private Map<String, BlockDefinition> structureBlockStates;
        @Generated
        private List<BlockPropertyData> blockProperties;
        @Generated
        private Object2ObjectMap<CustomBlockState, GeyserBedrockBlock> customBlockStateDefinitions;
        @Generated
        private Int2ObjectMap<GeyserBedrockBlock> extendedCollisionBoxes;

        @Generated
        BlockMappingsBuilder() {
        }

        @Generated
        public BlockMappingsBuilder bedrockAir(GeyserBedrockBlock bedrockAir) {
            this.bedrockAir = bedrockAir;
            return this;
        }

        @Generated
        public BlockMappingsBuilder bedrockWater(BlockDefinition bedrockWater) {
            this.bedrockWater = bedrockWater;
            return this;
        }

        @Generated
        public BlockMappingsBuilder bedrockMovingBlock(BlockDefinition bedrockMovingBlock) {
            this.bedrockMovingBlock = bedrockMovingBlock;
            return this;
        }

        @Generated
        public BlockMappingsBuilder javaToBedrockBlocks(GeyserBedrockBlock[] javaToBedrockBlocks) {
            this.javaToBedrockBlocks = javaToBedrockBlocks;
            return this;
        }

        @Generated
        public BlockMappingsBuilder javaToVanillaBedrockBlocks(GeyserBedrockBlock[] javaToVanillaBedrockBlocks) {
            this.javaToVanillaBedrockBlocks = javaToVanillaBedrockBlocks;
            return this;
        }

        @Generated
        public BlockMappingsBuilder javaToBedrockIdentifiers(Int2ObjectMap<String> javaToBedrockIdentifiers) {
            this.javaToBedrockIdentifiers = javaToBedrockIdentifiers;
            return this;
        }

        @Generated
        public BlockMappingsBuilder stateDefinitionMap(Map<NbtMap, GeyserBedrockBlock> stateDefinitionMap) {
            this.stateDefinitionMap = stateDefinitionMap;
            return this;
        }

        @Generated
        public BlockMappingsBuilder bedrockRuntimeMap(GeyserBedrockBlock[] bedrockRuntimeMap) {
            this.bedrockRuntimeMap = bedrockRuntimeMap;
            return this;
        }

        @Generated
        public BlockMappingsBuilder remappedVanillaIds(int[] remappedVanillaIds) {
            this.remappedVanillaIds = remappedVanillaIds;
            return this;
        }

        @Generated
        public BlockMappingsBuilder commandBlock(BlockDefinition commandBlock) {
            this.commandBlock = commandBlock;
            return this;
        }

        @Generated
        public BlockMappingsBuilder mobSpawnerBlock(BlockDefinition mobSpawnerBlock) {
            this.mobSpawnerBlock = mobSpawnerBlock;
            return this;
        }

        @Generated
        public BlockMappingsBuilder netherPortalBlock(BlockDefinition netherPortalBlock) {
            this.netherPortalBlock = netherPortalBlock;
            return this;
        }

        @Generated
        public BlockMappingsBuilder collisionIgnoredBlocks(IntArrayList collisionIgnoredBlocks) {
            this.collisionIgnoredBlocks = collisionIgnoredBlocks;
            return this;
        }

        @Generated
        public BlockMappingsBuilder itemFrames(Map<NbtMap, BlockDefinition> itemFrames) {
            this.itemFrames = itemFrames;
            return this;
        }

        @Generated
        public BlockMappingsBuilder flowerPotBlocks(Map<Block, NbtMap> flowerPotBlocks) {
            this.flowerPotBlocks = flowerPotBlocks;
            return this;
        }

        @Generated
        public BlockMappingsBuilder jigsawStates(Set<BlockDefinition> jigsawStates) {
            this.jigsawStates = jigsawStates;
            return this;
        }

        @Generated
        public BlockMappingsBuilder structureBlockStates(Map<String, BlockDefinition> structureBlockStates) {
            this.structureBlockStates = structureBlockStates;
            return this;
        }

        @Generated
        public BlockMappingsBuilder blockProperties(List<BlockPropertyData> blockProperties) {
            this.blockProperties = blockProperties;
            return this;
        }

        @Generated
        public BlockMappingsBuilder customBlockStateDefinitions(Object2ObjectMap<CustomBlockState, GeyserBedrockBlock> customBlockStateDefinitions) {
            this.customBlockStateDefinitions = customBlockStateDefinitions;
            return this;
        }

        @Generated
        public BlockMappingsBuilder extendedCollisionBoxes(Int2ObjectMap<GeyserBedrockBlock> extendedCollisionBoxes) {
            this.extendedCollisionBoxes = extendedCollisionBoxes;
            return this;
        }

        @Generated
        public BlockMappings build() {
            return new BlockMappings(this.bedrockAir, this.bedrockWater, this.bedrockMovingBlock, this.javaToBedrockBlocks, this.javaToVanillaBedrockBlocks, this.javaToBedrockIdentifiers, this.stateDefinitionMap, this.bedrockRuntimeMap, this.remappedVanillaIds, this.commandBlock, this.mobSpawnerBlock, this.netherPortalBlock, this.collisionIgnoredBlocks, this.itemFrames, this.flowerPotBlocks, this.jigsawStates, this.structureBlockStates, this.blockProperties, this.customBlockStateDefinitions, this.extendedCollisionBoxes);
        }

        @Generated
        public String toString() {
            return "BlockMappings.BlockMappingsBuilder(bedrockAir=" + String.valueOf(this.bedrockAir) + ", bedrockWater=" + String.valueOf(this.bedrockWater) + ", bedrockMovingBlock=" + String.valueOf(this.bedrockMovingBlock) + ", javaToBedrockBlocks=" + Arrays.deepToString(this.javaToBedrockBlocks) + ", javaToVanillaBedrockBlocks=" + Arrays.deepToString(this.javaToVanillaBedrockBlocks) + ", javaToBedrockIdentifiers=" + String.valueOf(this.javaToBedrockIdentifiers) + ", stateDefinitionMap=" + String.valueOf(this.stateDefinitionMap) + ", bedrockRuntimeMap=" + Arrays.deepToString(this.bedrockRuntimeMap) + ", remappedVanillaIds=" + Arrays.toString(this.remappedVanillaIds) + ", commandBlock=" + String.valueOf(this.commandBlock) + ", mobSpawnerBlock=" + String.valueOf(this.mobSpawnerBlock) + ", netherPortalBlock=" + String.valueOf(this.netherPortalBlock) + ", collisionIgnoredBlocks=" + String.valueOf(this.collisionIgnoredBlocks) + ", itemFrames=" + String.valueOf(this.itemFrames) + ", flowerPotBlocks=" + String.valueOf(this.flowerPotBlocks) + ", jigsawStates=" + String.valueOf(this.jigsawStates) + ", structureBlockStates=" + String.valueOf(this.structureBlockStates) + ", blockProperties=" + String.valueOf(this.blockProperties) + ", customBlockStateDefinitions=" + String.valueOf(this.customBlockStateDefinitions) + ", extendedCollisionBoxes=" + String.valueOf(this.extendedCollisionBoxes) + ")";
        }
    }
}

