/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.mappings.predicate;

import com.google.gson.JsonElement;
import org.geysermc.geyser.api.predicate.MatchPredicate;
import org.geysermc.geyser.api.predicate.MinecraftPredicate;
import org.geysermc.geyser.api.predicate.context.item.ItemPredicateContext;
import org.geysermc.geyser.api.predicate.item.ItemMatchPredicate;
import org.geysermc.geyser.item.exception.InvalidCustomMappingsFileException;
import org.geysermc.geyser.registry.mappings.predicate.PredicateCreator;
import org.geysermc.geyser.registry.mappings.predicate.PredicateReader;
import org.geysermc.geyser.registry.mappings.util.MappingsUtil;
import org.geysermc.geyser.registry.mappings.util.NodeReader;

public enum ItemMatchProperty implements PredicateReader<ItemPredicateContext>
{
    CHARGE_TYPE(ItemMatchPredicate::chargeType, NodeReader.CHARGE_TYPE),
    TRIM_MATERIAL(ItemMatchPredicate::trimMaterial, NodeReader.IDENTIFIER),
    CONTEXT_DIMENSION((element, context) -> MatchPredicate.dimension(ItemMatchProperty.readValue(element, NodeReader.IDENTIFIER, context))),
    CUSTOM_MODEL_DATA((element, context) -> {
        int index = MappingsUtil.readOrDefault(element, "index", NodeReader.NON_NEGATIVE_INT, 0, context);
        return ItemMatchPredicate.customModelData(index, ItemMatchProperty.readValue(element, NodeReader.STRING, context));
    });

    private final PredicateReader<? super ItemPredicateContext> reader;

    private ItemMatchProperty(PredicateReader<? super ItemPredicateContext> reader) {
        this.reader = reader;
    }

    private <T> ItemMatchProperty(PredicateCreator<? super ItemPredicateContext, T> creator, NodeReader<T> reader) {
        this((element, context) -> creator.create(ItemMatchProperty.readValue(element, reader, context)));
    }

    private static <T> T readValue(JsonElement element, NodeReader<T> reader, String ... context) throws InvalidCustomMappingsFileException {
        return MappingsUtil.readOrThrow(element, "value", reader, context);
    }

    @Override
    public MinecraftPredicate<? super ItemPredicateContext> read(JsonElement element, String ... context) throws InvalidCustomMappingsFileException {
        return this.reader.read(element, context);
    }
}

