/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.loader;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Map;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.registry.loader.RegistryLoader;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.biome.BiomeDefinitionData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.biome.BiomeDefinitions;

public class BiomeLoader
implements RegistryLoader<String, BiomeDefinitions> {
    private final Gson GSON = new GsonBuilder().registerTypeAdapter(Color.class, (Object)new ColorTypeAdapter()).create();

    @Override
    public BiomeDefinitions load(String input) {
        Map biomes;
        Type type = new TypeToken<Map<String, BiomeDefinitionData>>(){}.getType();
        try (InputStream stream = GeyserImpl.getInstance().getBootstrap().getResourceOrThrow(input);){
            biomes = (Map)this.GSON.fromJson((Reader)new InputStreamReader(stream), type);
        }
        catch (Exception e) {
            throw new AssertionError("Unable to load Bedrock biomes!", e);
        }
        return new BiomeDefinitions(biomes);
    }

    public static class ColorTypeAdapter
    extends TypeAdapter<Color> {
        public void write(JsonWriter out, Color color) throws IOException {
            if (color == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            out.name("r").value((long)color.getRed());
            out.name("g").value((long)color.getGreen());
            out.name("b").value((long)color.getBlue());
            out.name("a").value((long)color.getAlpha());
            out.endObject();
        }

        public Color read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            int r = 0;
            int g = 0;
            int b = 0;
            int a = 255;
            in.beginObject();
            block12: while (in.hasNext()) {
                switch (in.nextName()) {
                    case "r": {
                        r = in.nextInt();
                        continue block12;
                    }
                    case "g": {
                        g = in.nextInt();
                        continue block12;
                    }
                    case "b": {
                        b = in.nextInt();
                        continue block12;
                    }
                    case "a": {
                        a = in.nextInt();
                        continue block12;
                    }
                }
                in.skipValue();
            }
            in.endObject();
            return new Color(r, g, b, a);
        }
    }
}

