/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.fabric;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.server.MinecraftServer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.api.util.PlatformType;
import org.geysermc.geyser.dump.BootstrapDumpInfo;
import org.geysermc.geyser.platform.fabric.GeyserFabricDumpInfo;
import org.geysermc.geyser.platform.mod.GeyserModBootstrap;
import org.geysermc.geyser.platform.mod.platform.GeyserModPlatform;

public class GeyserFabricPlatform
implements GeyserModPlatform {
    private final ModContainer mod = (ModContainer)FabricLoader.getInstance().getModContainer("geyser-fabric").orElseThrow();

    @Override
    public @NonNull PlatformType platformType() {
        return PlatformType.FABRIC;
    }

    @Override
    public @NonNull String configPath() {
        return "Geyser-Fabric";
    }

    @Override
    public @NonNull Path dataFolder(@NonNull String modId) {
        return FabricLoader.getInstance().getConfigDir().resolve(modId);
    }

    @Override
    public @NonNull BootstrapDumpInfo dumpInfo(@NonNull MinecraftServer server) {
        return new GeyserFabricDumpInfo(server);
    }

    @Override
    public boolean testFloodgatePluginPresent(@NonNull GeyserModBootstrap bootstrap) {
        Optional floodgate = FabricLoader.getInstance().getModContainer("floodgate");
        if (floodgate.isPresent()) {
            Path floodgateDataFolder = FabricLoader.getInstance().getConfigDir().resolve("floodgate");
            bootstrap.loadFloodgate(floodgateDataFolder);
            return true;
        }
        return false;
    }

    @Override
    public @Nullable InputStream resolveResource(@NonNull String resource) {
        Path path = this.mod.findPath(resource).orElse(null);
        if (path == null) {
            return null;
        }
        try {
            return path.getFileSystem().provider().newInputStream(path, new OpenOption[0]);
        }
        catch (IOException e) {
            return null;
        }
    }
}

