/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.network.netty;

import io.netty.channel.Channel;
import io.netty.channel.DefaultChannelPipeline;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import java.net.InetSocketAddress;
import java.util.Objects;
import org.geysermc.geyser.network.netty.ChannelWrapper;
import org.geysermc.geyser.network.netty.DefaultChannelPipelinePublic;

public class LocalChannelWrapper
extends LocalChannel {
    private final ChannelWrapper wrapper;
    private volatile ChannelWrapper tempWrapper;

    public LocalChannelWrapper(LocalServerChannel parent, LocalChannel peer) {
        super(parent, peer);
        this.wrapper = Objects.requireNonNullElseGet(this.tempWrapper, () -> new ChannelWrapper((Channel)this));
        this.wrapper.remoteAddress(new InetSocketAddress(0));
    }

    public ChannelWrapper wrapper() {
        return this.wrapper;
    }

    protected DefaultChannelPipeline newChannelPipeline() {
        if (this.wrapper != null) {
            return new DefaultChannelPipelinePublic(this.wrapper);
        }
        if (this.tempWrapper != null) {
            return new DefaultChannelPipelinePublic(this.tempWrapper);
        }
        this.tempWrapper = new ChannelWrapper((Channel)this);
        return new DefaultChannelPipelinePublic(this.tempWrapper);
    }
}

