/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.type;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.nbt.NbtType;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.item.Potion;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.TooltipOptions;
import org.geysermc.geyser.item.type.ArrowItem;
import org.geysermc.geyser.item.type.BlockItem;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.item.type.PotionItem;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.definitions.ItemDefinition;
import org.geysermc.geyser.translator.item.BedrockItemBuilder;
import org.geysermc.geyser.translator.item.CustomItemTranslator;
import org.geysermc.geyser.translator.item.ItemTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.PotionContents;

public class ShulkerBoxItem
extends BlockItem {
    public ShulkerBoxItem(Item.Builder builder, Block block, Block ... otherBlocks) {
        super(builder, block, otherBlocks);
    }

    @Override
    public void translateComponentsToBedrock(@NonNull GeyserSession session, @NonNull DataComponents components, @NonNull TooltipOptions tooltip, @NonNull BedrockItemBuilder builder) {
        super.translateComponentsToBedrock(session, components, tooltip, builder);
        List<ItemStack> contents = components.get(DataComponentTypes.CONTAINER);
        if (contents == null || contents.isEmpty()) {
            return;
        }
        ArrayList<NbtMap> itemsList = new ArrayList<NbtMap>();
        for (int slot = 0; slot < contents.size(); ++slot) {
            Object customName;
            ItemStack item = contents.get(slot);
            if (item == null || item.getId() == Items.AIR_ID) continue;
            ItemMapping boxMapping = session.getItemMappings().getMapping(item.getId());
            int bedrockData = boxMapping.getBedrockData();
            String bedrockIdentifier = boxMapping.getBedrockIdentifier();
            DataComponents boxComponents = item.getDataComponentsPatch();
            if (boxComponents != null) {
                Potion potion;
                PotionContents potionContents;
                boxComponents = Objects.requireNonNull(GeyserItemStack.from(session, item).getAllComponents());
                ItemDefinition customItemDefinition = CustomItemTranslator.getCustomItem(session, item.getAmount(), boxComponents, boxMapping);
                if (customItemDefinition != null) {
                    bedrockIdentifier = customItemDefinition.getIdentifier();
                    bedrockData = 0;
                } else if ((boxMapping.getJavaItem() instanceof PotionItem || boxMapping.getJavaItem() instanceof ArrowItem) && (potionContents = boxComponents.get(DataComponentTypes.POTION_CONTENTS)) != null && (potion = Potion.getByJavaId(potionContents.getPotionId())) != null) {
                    bedrockData = potion.getBedrockId();
                }
            }
            NbtMapBuilder boxItemNbt = BedrockItemBuilder.createItemNbt(bedrockIdentifier, item.getAmount(), bedrockData);
            boxItemNbt.putByte("Slot", (byte)slot);
            boxItemNbt.putByte("WasPickedUp", (byte)0);
            if (boxComponents != null && (customName = ItemTranslator.getCustomName(session, boxComponents, boxMapping, '7', false, true)) != null) {
                if (((String)customName).contains("\u00a7")) {
                    customName = (String)customName + "\u00a7r\u00a77";
                }
                boxItemNbt.putCompound("tag", NbtMap.builder().putCompound("display", NbtMap.builder().putString("Name", (String)customName).build()).build());
            }
            itemsList.add(boxItemNbt.build());
        }
        builder.putList("Items", NbtType.COMPOUND, itemsList);
    }
}

