/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.player;

import java.util.Collections;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3f;
import org.geysermc.geyser.api.entity.type.player.GeyserPlayerEntity;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.entity.attribute.GeyserAttributeType;
import org.geysermc.geyser.entity.type.living.animal.tameable.ParrotEntity;
import org.geysermc.geyser.entity.type.player.AvatarEntity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityLinkData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.SetEntityLinkPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.UpdateAttributesPacket;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.EntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.Pose;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.FloatEntityMetadata;

public class PlayerEntity
extends AvatarEntity
implements GeyserPlayerEntity {
    private @Nullable ParrotEntity leftParrot;
    private @Nullable ParrotEntity rightParrot;
    private boolean listed = false;

    public PlayerEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw, String username, @Nullable String texturesProperty) {
        super(session, entityId, geyserId, uuid, EntityDefinitions.PLAYER, position, motion, yaw, pitch, headYaw, username);
        this.texturesProperty = texturesProperty;
    }

    @Override
    protected void initializeMetadata() {
        super.initializeMetadata();
        this.dirtyMetadata.put(EntityDataTypes.NAMETAG_ALWAYS_SHOW, (byte)1);
    }

    @Override
    public void despawnEntity() {
        super.despawnEntity();
        this.resetMetadata();
        this.nametag = this.username;
        this.equipment.clear();
    }

    public void resetMetadata() {
        this.flags.clear();
        this.initializeMetadata();
        this.setParrot(OptionalInt.empty(), true);
        this.setParrot(OptionalInt.empty(), false);
    }

    public void sendPlayer() {
        if (this.session.getEntityCache().getPlayerEntity(this.uuid) == null) {
            return;
        }
        this.session.getEntityCache().spawnEntity(this);
    }

    @Override
    public void moveAbsolute(Vector3f position, float yaw, float pitch, float headYaw, boolean isOnGround, boolean teleported) {
        super.moveAbsolute(position, yaw, pitch, headYaw, isOnGround, teleported);
        if (this.leftParrot != null) {
            this.leftParrot.moveAbsolute(position, yaw, pitch, headYaw, true, teleported);
        }
        if (this.rightParrot != null) {
            this.rightParrot.moveAbsolute(position, yaw, pitch, headYaw, true, teleported);
        }
    }

    @Override
    public void moveRelative(double relX, double relY, double relZ, float yaw, float pitch, float headYaw, boolean isOnGround) {
        super.moveRelative(relX, relY, relZ, yaw, pitch, headYaw, isOnGround);
        if (this.leftParrot != null) {
            this.leftParrot.moveRelative(relX, relY, relZ, yaw, pitch, headYaw, true);
        }
        if (this.rightParrot != null) {
            this.rightParrot.moveRelative(relX, relY, relZ, yaw, pitch, headYaw, true);
        }
    }

    public void setAbsorptionHearts(FloatEntityMetadata entityMetadata) {
        UpdateAttributesPacket attributesPacket = new UpdateAttributesPacket();
        attributesPacket.setRuntimeEntityId(this.geyserId);
        attributesPacket.setAttributes(Collections.singletonList(GeyserAttributeType.ABSORPTION.getAttribute(entityMetadata.getPrimitiveValue())));
        this.session.sendUpstreamPacket(attributesPacket);
    }

    public void setLeftParrot(EntityMetadata<OptionalInt, ?> entityMetadata) {
        this.setParrot(entityMetadata.getValue(), true);
    }

    public void setRightParrot(EntityMetadata<OptionalInt, ?> entityMetadata) {
        this.setParrot(entityMetadata.getValue(), false);
    }

    protected void setParrot(OptionalInt variant, boolean isLeft) {
        if (variant.isPresent()) {
            if (isLeft && this.leftParrot != null || !isLeft && this.rightParrot != null) {
                return;
            }
            ParrotEntity parrot = new ParrotEntity(this.session, 0, this.session.getEntityCache().getNextEntityId().incrementAndGet(), null, EntityDefinitions.PARROT, this.position, this.motion, this.getYaw(), this.getPitch(), this.getHeadYaw());
            parrot.spawnEntity();
            parrot.getDirtyMetadata().put(EntityDataTypes.VARIANT, variant.getAsInt());
            float offset = isLeft ? 0.4f : -0.4f;
            parrot.getDirtyMetadata().put(EntityDataTypes.SEAT_OFFSET, Vector3f.from((double)offset, (double)-0.22, (double)-0.1));
            parrot.getDirtyMetadata().put(EntityDataTypes.SEAT_LOCK_RIDER_ROTATION, true);
            parrot.updateBedrockMetadata();
            SetEntityLinkPacket linkPacket = new SetEntityLinkPacket();
            EntityLinkData.Type type = isLeft ? EntityLinkData.Type.RIDER : EntityLinkData.Type.PASSENGER;
            linkPacket.setEntityLink(new EntityLinkData(this.geyserId, parrot.getGeyserId(), type, false, false, 0.0f));
            this.session.scheduleInEventLoop(() -> this.session.sendUpstreamPacket(linkPacket), 500L, TimeUnit.MILLISECONDS);
            if (isLeft) {
                this.leftParrot = parrot;
            } else {
                this.rightParrot = parrot;
            }
        } else {
            ParrotEntity parrot;
            ParrotEntity parrotEntity = parrot = isLeft ? this.leftParrot : this.rightParrot;
            if (parrot != null) {
                parrot.despawnEntity();
                if (isLeft) {
                    this.leftParrot = null;
                } else {
                    this.rightParrot = null;
                }
            }
        }
    }

    @Override
    public String teamIdentifier() {
        return this.username;
    }

    @Override
    protected void setNametag(@Nullable String nametag, boolean fromDisplayName) {
        if (nametag == null && !fromDisplayName) {
            nametag = this.username;
        }
        super.setNametag(nametag, fromDisplayName);
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public UUID getTabListUuid() {
        return this.getUuid();
    }

    @Override
    public Vector3f position() {
        return this.position.down(this.definition.offset());
    }

    public Pose getDesiredPose() {
        if (this.getBedPosition() != null) {
            return Pose.SLEEPING;
        }
        if (this.getFlag(EntityFlag.SWIMMING) || this.getFlag(EntityFlag.CRAWLING)) {
            return Pose.SWIMMING;
        }
        if (this.getFlag(EntityFlag.GLIDING)) {
            return Pose.FALL_FLYING;
        }
        if (this.getFlag(EntityFlag.DAMAGE_NEARBY_MOBS)) {
            return Pose.SPIN_ATTACK;
        }
        return this.getFlag(EntityFlag.SNEAKING) && !this.session.isFlying() ? Pose.SNEAKING : Pose.STANDING;
    }

    @Generated
    public @Nullable ParrotEntity getLeftParrot() {
        return this.leftParrot;
    }

    @Generated
    public @Nullable ParrotEntity getRightParrot() {
        return this.rightParrot;
    }

    @Generated
    public boolean isListed() {
        return this.listed;
    }

    @Generated
    public void setListed(boolean listed) {
        this.listed = listed;
    }
}

