/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.monster;

import java.util.UUID;
import org.cloudburstmc.math.vector.Vector3f;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.living.monster.MonsterEntity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.BooleanEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.ByteEntityMetadata;

public class BasePiglinEntity
extends MonsterEntity {
    private boolean isImmuneToZombification;

    public BasePiglinEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
        this.dirtyMetadata.put(EntityDataTypes.BLOCK, session.getBlockMappings().getDefinition(1));
        this.setFlag(EntityFlag.SHAKING, this.isShaking());
    }

    @Override
    public void setMobFlags(ByteEntityMetadata entityMetadata) {
        super.setMobFlags(entityMetadata);
        byte xd = entityMetadata.getPrimitiveValue();
        this.dirtyMetadata.put(EntityDataTypes.TARGET_EID, (xd & 4) == 4 ? this.session.getPlayerEntity().getGeyserId() : 0L);
    }

    public void setImmuneToZombification(BooleanEntityMetadata entityMetadata) {
        this.isImmuneToZombification = entityMetadata.getPrimitiveValue();
        this.setFlag(EntityFlag.SHAKING, this.isShaking());
    }

    @Override
    protected boolean isShaking() {
        return !this.isImmuneToZombification && !this.session.getDimensionType().piglinSafe() || super.isShaking();
    }

    @Override
    public boolean useArmSwingAttack() {
        return true;
    }
}

