/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.animal;

import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3f;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.properties.type.BooleanProperty;
import org.geysermc.geyser.entity.type.living.animal.AnimalEntity;
import org.geysermc.geyser.impl.IdentifierImpl;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.tags.ItemTag;
import org.geysermc.geyser.session.cache.tags.Tag;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityEventType;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.EntityEventPacket;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.ByteEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.LongEntityMetadata;

public class BeeEntity
extends AnimalEntity {
    public static final BooleanProperty NECTAR_PROPERTY = new BooleanProperty(IdentifierImpl.of("has_nectar"), false);

    public BeeEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    public void setBeeFlags(ByteEntityMetadata entityMetadata) {
        byte xd = entityMetadata.getPrimitiveValue();
        if ((xd & 2) == 2) {
            EntityEventPacket packet = new EntityEventPacket();
            packet.setRuntimeEntityId(this.geyserId);
            packet.setType(EntityEventType.ATTACK_START);
            packet.setData(0);
            this.session.sendUpstreamPacket(packet);
        }
        this.dirtyMetadata.put(EntityDataTypes.MARK_VARIANT, (xd & 4) == 4 ? 1 : 0);
        NECTAR_PROPERTY.apply(this.propertyManager, (xd & 8) == 8);
        this.updateBedrockEntityProperties();
    }

    public void setAngerTime(LongEntityMetadata entityMetadata) {
        this.setFlag(EntityFlag.ANGRY, entityMetadata.getPrimitiveValue() > 0L);
    }

    @Override
    protected @Nullable Tag<Item> getFoodTag() {
        return ItemTag.BEE_FOOD;
    }
}

