/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type;

import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.cloudburstmc.math.vector.Vector3f;
import org.geysermc.erosion.util.BlockPositionIterator;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.ThrowableEntity;
import org.geysermc.geyser.entity.type.player.PlayerEntity;
import org.geysermc.geyser.level.block.BlockStateValues;
import org.geysermc.geyser.level.physics.BoundingBox;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.PlaySoundPacket;
import org.geysermc.geyser.translator.collision.BlockCollision;
import org.geysermc.geyser.util.BlockUtils;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.IntEntityMetadata;

public class FishingHookEntity
extends ThrowableEntity {
    private boolean hooked = false;
    private boolean castByPlayer = false;
    private boolean inWater = false;
    private final long bedrockOwnerId;
    private long bedrockTargetId;
    private final BoundingBox boundingBox = new BoundingBox(0.125, 0.125, 0.125, 0.25, 0.25, 0.25);

    public FishingHookEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw, PlayerEntity owner) {
        super(session, entityId, geyserId, uuid, EntityDefinitions.FISHING_BOBBER, position, motion, yaw, pitch, 0.0f);
        this.setBoundingBoxHeight(128.0f);
        this.bedrockOwnerId = owner.getGeyserId();
        this.dirtyMetadata.put(EntityDataTypes.OWNER_EID, this.bedrockOwnerId);
        if (owner == session.getPlayerEntity()) {
            session.setFishingRodCast(true);
            this.castByPlayer = true;
        }
    }

    @Override
    public void despawnEntity() {
        if (this.castByPlayer) {
            this.session.setFishingRodCast(false);
        }
        super.despawnEntity();
    }

    public void setHookedEntity(IntEntityMetadata entityMetadata) {
        int hookedEntityId = entityMetadata.getPrimitiveValue() - 1;
        Entity entity = this.session.getEntityCache().getEntityByJavaId(hookedEntityId);
        if (entity != null) {
            this.bedrockTargetId = entity.getGeyserId();
            this.dirtyMetadata.put(EntityDataTypes.TARGET_EID, this.bedrockTargetId);
            this.hooked = true;
        } else {
            this.hooked = false;
        }
    }

    @Override
    protected void moveAbsoluteImmediate(Vector3f position, float yaw, float pitch, float headYaw, boolean isOnGround, boolean teleported) {
        this.boundingBox.setMiddleX(position.getX());
        this.boundingBox.setMiddleY((double)position.getY() + this.boundingBox.getSizeY() / 2.0);
        this.boundingBox.setMiddleZ(position.getZ());
        boolean touchingWater = false;
        boolean collided = false;
        BlockPositionIterator iter = this.session.getCollisionManager().collidableBlocksIterator(this.boundingBox);
        while (iter.hasNext()) {
            double waterHeight;
            int blockID = this.session.getGeyser().getWorldManager().getBlockAt(this.session, iter.getX(), iter.getY(), iter.getZ());
            BlockCollision blockCollision = BlockUtils.getCollision(blockID);
            if (blockCollision != null && blockCollision.checkIntersection(iter.getX(), iter.getY(), iter.getZ(), this.boundingBox)) {
                collided = true;
            }
            if ((waterHeight = BlockStateValues.getWaterHeight(blockID)) != -1.0 && (double)position.getY() <= (double)iter.getY() + waterHeight) {
                touchingWater = true;
            }
            iter.next();
        }
        if (!this.inWater && touchingWater) {
            this.sendSplashSound(this.session);
        }
        this.inWater = touchingWater;
        if (!collided) {
            super.moveAbsoluteImmediate(position, yaw, pitch, headYaw, isOnGround, teleported);
        } else {
            super.moveAbsoluteImmediate(this.position, yaw, pitch, headYaw, true, true);
        }
    }

    private void sendSplashSound(GeyserSession session) {
        if (!this.silent) {
            float volume = (float)((double)0.2f * Math.sqrt(0.2 * (double)(this.motion.getX() * this.motion.getX() + this.motion.getZ() * this.motion.getZ()) + (double)(this.motion.getY() * this.motion.getY())));
            if (volume > 1.0f) {
                volume = 1.0f;
            }
            PlaySoundPacket playSoundPacket = new PlaySoundPacket();
            playSoundPacket.setSound("random.splash");
            playSoundPacket.setPosition(this.position);
            playSoundPacket.setVolume(volume);
            playSoundPacket.setPitch(1.0f + ThreadLocalRandom.current().nextFloat() * 0.3f);
            session.sendUpstreamPacket(playSoundPacket);
        }
    }

    @Override
    public void tick() {
        if (this.removedInVoid()) {
            return;
        }
        if (this.hooked || !this.isInAir() && !this.isInWater() || this.isOnGround()) {
            this.motion = Vector3f.ZERO;
            return;
        }
        float gravity = this.getGravity();
        this.motion = this.motion.down(gravity);
        this.moveAbsoluteImmediate(this.position.add(this.motion), this.getYaw(), this.getPitch(), this.getHeadYaw(), this.isOnGround(), false);
        float drag = this.getDrag();
        this.motion = this.motion.mul(drag);
    }

    @Override
    protected float getGravity() {
        if (!this.isInWater() && !this.isOnGround()) {
            return 0.03f;
        }
        return 0.0f;
    }

    protected boolean isInAir() {
        int block = this.session.getGeyser().getWorldManager().getBlockAt(this.session, this.position.toInt());
        return block == 0;
    }

    @Override
    protected float getDrag() {
        return 0.92f;
    }

    @Generated
    public long getBedrockOwnerId() {
        return this.bedrockOwnerId;
    }

    @Generated
    public long getBedrockTargetId() {
        return this.bedrockTargetId;
    }
}

