/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type;

import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.cloudburstmc.math.vector.Vector3f;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.Tickable;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.PlaySoundPacket;

public class EvokerFangsEntity
extends Entity
implements Tickable {
    private int limitedLife = 22;
    private boolean attackStarted = false;

    public EvokerFangsEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
        this.dirtyMetadata.put(EntityDataTypes.DATA_LIFETIME_TICKS, this.limitedLife);
    }

    @Override
    public void tick() {
        if (this.attackStarted && --this.limitedLife > 0 && this.limitedLife % 2 == 0) {
            this.dirtyMetadata.put(EntityDataTypes.DATA_LIFETIME_TICKS, this.limitedLife);
            this.updateBedrockMetadata();
        }
    }

    public void setAttackStarted() {
        this.attackStarted = true;
        if (!this.silent) {
            PlaySoundPacket packet = new PlaySoundPacket();
            packet.setPosition(this.position);
            packet.setSound("mob.evocation_fangs.attack");
            packet.setVolume(1.0f);
            packet.setPitch(ThreadLocalRandom.current().nextFloat() * 0.2f + 0.85f);
            this.session.sendUpstreamPacket(packet);
        }
    }
}

