/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.command;

import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.command.GeyserCommandSource;
import org.geysermc.geyser.session.GeyserSession;
import org.incendo.cloud.SenderMapper;

public record CommandSourceConverter<S>(Class<S> senderType, Function<UUID, S> playerLookup, Supplier<S> consoleProvider, Function<S, GeyserCommandSource> commandSourceLookup) implements SenderMapper<S, GeyserCommandSource>
{
    public static <P, S> CommandSourceConverter<S> layered(Class<S> senderType, Function<UUID, P> playerLookup, Function<P, S> senderLookup, Supplier<S> consoleProvider, Function<S, GeyserCommandSource> commandSourceLookup) {
        Function<UUID, Object> lookup = uuid -> {
            Object player = playerLookup.apply((UUID)uuid);
            if (player == null) {
                return null;
            }
            return senderLookup.apply(player);
        };
        return new CommandSourceConverter<Object>(senderType, lookup, consoleProvider, commandSourceLookup);
    }

    public @NonNull GeyserCommandSource map(@NonNull S base) {
        return this.commandSourceLookup.apply(base);
    }

    public @NonNull S reverse(GeyserCommandSource source) throws IllegalArgumentException {
        UUID uuid;
        GeyserLogger logger;
        Object handle = source.handle();
        if (this.senderType.isInstance(handle)) {
            return this.senderType.cast(handle);
        }
        if (source.isConsole()) {
            return this.consoleProvider.get();
        }
        if (!(source instanceof GeyserSession) && (logger = GeyserImpl.getInstance().getLogger()).isDebug()) {
            logger.debug("Falling back to UUID for command sender lookup for a command source that is not a GeyserSession: " + String.valueOf(source));
            Thread.dumpStack();
        }
        if ((uuid = source.playerUuid()) != null) {
            return this.playerLookup.apply(uuid);
        }
        throw new IllegalArgumentException("failed to find sender for name=%s, uuid=%s".formatted(source.name(), source.playerUuid()));
    }
}

