/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.util;

import lombok.Generated;
import org.geysermc.floodgate.util.LinkedPlayer;

public final class BedrockData
implements Cloneable {
    public static final int EXPECTED_LENGTH = 12;
    private final String version;
    private final String username;
    private final String xuid;
    private final int deviceOs;
    private final String languageCode;
    private final int uiProfile;
    private final int inputMode;
    private final String ip;
    private final LinkedPlayer linkedPlayer;
    private final boolean fromProxy;
    private final int subscribeId;
    private final String verifyCode;
    private final int dataLength;

    public static BedrockData of(String version, String username, String xuid, int deviceOs, String languageCode, int uiProfile, int inputMode, String ip, LinkedPlayer linkedPlayer, boolean fromProxy, int subscribeId, String verifyCode) {
        return new BedrockData(version, username, xuid, deviceOs, languageCode, inputMode, uiProfile, ip, linkedPlayer, fromProxy, subscribeId, verifyCode, 12);
    }

    public static BedrockData of(String version, String username, String xuid, int deviceOs, String languageCode, int uiProfile, int inputMode, String ip, int subscribeId, String verifyCode) {
        return BedrockData.of(version, username, xuid, deviceOs, languageCode, uiProfile, inputMode, ip, null, false, subscribeId, verifyCode);
    }

    public static BedrockData fromString(String data) {
        String[] split = data.split("\u0000");
        if (split.length != 12) {
            return BedrockData.emptyData(split.length);
        }
        LinkedPlayer linkedPlayer = LinkedPlayer.fromString(split[8]);
        return new BedrockData(split[0], split[1], split[2], Integer.parseInt(split[3]), split[4], Integer.parseInt(split[5]), Integer.parseInt(split[6]), split[7], linkedPlayer, "1".equals(split[9]), Integer.parseInt(split[10]), split[11], split.length);
    }

    private static BedrockData emptyData(int dataLength) {
        return new BedrockData(null, null, null, -1, null, -1, -1, null, null, false, -1, null, dataLength);
    }

    public boolean hasPlayerLink() {
        return this.linkedPlayer != null;
    }

    public String toString() {
        return this.version + '\u0000' + this.username + '\u0000' + this.xuid + '\u0000' + this.deviceOs + '\u0000' + this.languageCode + '\u0000' + this.uiProfile + '\u0000' + this.inputMode + '\u0000' + this.ip + '\u0000' + (this.linkedPlayer != null ? this.linkedPlayer.toString() : "null") + '\u0000' + (this.fromProxy ? 1 : 0) + '\u0000' + this.subscribeId + '\u0000' + this.verifyCode;
    }

    public BedrockData clone() throws CloneNotSupportedException {
        return (BedrockData)super.clone();
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getXuid() {
        return this.xuid;
    }

    @Generated
    public int getDeviceOs() {
        return this.deviceOs;
    }

    @Generated
    public String getLanguageCode() {
        return this.languageCode;
    }

    @Generated
    public int getUiProfile() {
        return this.uiProfile;
    }

    @Generated
    public int getInputMode() {
        return this.inputMode;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public LinkedPlayer getLinkedPlayer() {
        return this.linkedPlayer;
    }

    @Generated
    public boolean isFromProxy() {
        return this.fromProxy;
    }

    @Generated
    public int getSubscribeId() {
        return this.subscribeId;
    }

    @Generated
    public String getVerifyCode() {
        return this.verifyCode;
    }

    @Generated
    public int getDataLength() {
        return this.dataLength;
    }

    @Generated
    private BedrockData(String version, String username, String xuid, int deviceOs, String languageCode, int uiProfile, int inputMode, String ip, LinkedPlayer linkedPlayer, boolean fromProxy, int subscribeId, String verifyCode, int dataLength) {
        this.version = version;
        this.username = username;
        this.xuid = xuid;
        this.deviceOs = deviceOs;
        this.languageCode = languageCode;
        this.uiProfile = uiProfile;
        this.inputMode = inputMode;
        this.ip = ip;
        this.linkedPlayer = linkedPlayer;
        this.fromProxy = fromProxy;
        this.subscribeId = subscribeId;
        this.verifyCode = verifyCode;
        this.dataLength = dataLength;
    }
}

