/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.level.border;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ClientboundSetBorderSizePacket
implements MinecraftPacket {
    private final double size;

    public ClientboundSetBorderSizePacket(ByteBuf in) {
        this.size = in.readDouble();
    }

    @Override
    public void serialize(ByteBuf out) {
        out.writeDouble(this.size);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public double getSize() {
        return this.size;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSetBorderSizePacket)) {
            return false;
        }
        ClientboundSetBorderSizePacket other = (ClientboundSetBorderSizePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Double.compare(this.getSize(), other.getSize()) == 0;
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundSetBorderSizePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $size = Double.doubleToLongBits(this.getSize());
        result = result * 59 + (int)($size >>> 32 ^ $size);
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundSetBorderSizePacket(size=" + this.getSize() + ")";
    }

    public @NonNull ClientboundSetBorderSizePacket withSize(double size) {
        return this.size == size ? this : new ClientboundSetBorderSizePacket(size);
    }

    public ClientboundSetBorderSizePacket(double size) {
        this.size = size;
    }
}

