/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.inventory;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;

public class ClientboundContainerSetSlotPacket
implements MinecraftPacket {
    private final int containerId;
    private final int stateId;
    private final int slot;
    private final @Nullable ItemStack item;

    public ClientboundContainerSetSlotPacket(ByteBuf in) {
        this.containerId = MinecraftTypes.readVarInt(in);
        this.stateId = MinecraftTypes.readVarInt(in);
        this.slot = in.readShort();
        this.item = MinecraftTypes.readOptionalItemStack(in);
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeVarInt(out, this.containerId);
        MinecraftTypes.writeVarInt(out, this.stateId);
        out.writeShort(this.slot);
        MinecraftTypes.writeOptionalItemStack(out, this.item);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public int getContainerId() {
        return this.containerId;
    }

    public int getStateId() {
        return this.stateId;
    }

    public int getSlot() {
        return this.slot;
    }

    public @Nullable ItemStack getItem() {
        return this.item;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundContainerSetSlotPacket)) {
            return false;
        }
        ClientboundContainerSetSlotPacket other = (ClientboundContainerSetSlotPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getContainerId() != other.getContainerId()) {
            return false;
        }
        if (this.getStateId() != other.getStateId()) {
            return false;
        }
        if (this.getSlot() != other.getSlot()) {
            return false;
        }
        ItemStack this$item = this.getItem();
        ItemStack other$item = other.getItem();
        return !(this$item == null ? other$item != null : !((Object)this$item).equals(other$item));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundContainerSetSlotPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getContainerId();
        result = result * 59 + this.getStateId();
        result = result * 59 + this.getSlot();
        ItemStack $item = this.getItem();
        result = result * 59 + ($item == null ? 43 : ((Object)$item).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundContainerSetSlotPacket(containerId=" + this.getContainerId() + ", stateId=" + this.getStateId() + ", slot=" + this.getSlot() + ", item=" + String.valueOf(this.getItem()) + ")";
    }

    public @NonNull ClientboundContainerSetSlotPacket withContainerId(int containerId) {
        return this.containerId == containerId ? this : new ClientboundContainerSetSlotPacket(containerId, this.stateId, this.slot, this.item);
    }

    public @NonNull ClientboundContainerSetSlotPacket withStateId(int stateId) {
        return this.stateId == stateId ? this : new ClientboundContainerSetSlotPacket(this.containerId, stateId, this.slot, this.item);
    }

    public @NonNull ClientboundContainerSetSlotPacket withSlot(int slot) {
        return this.slot == slot ? this : new ClientboundContainerSetSlotPacket(this.containerId, this.stateId, slot, this.item);
    }

    public @NonNull ClientboundContainerSetSlotPacket withItem(@Nullable ItemStack item) {
        return this.item == item ? this : new ClientboundContainerSetSlotPacket(this.containerId, this.stateId, this.slot, item);
    }

    public ClientboundContainerSetSlotPacket(int containerId, int stateId, int slot, @Nullable ItemStack item) {
        this.containerId = containerId;
        this.stateId = stateId;
        this.slot = slot;
        this.item = item;
    }
}

