/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.geysermc.mcprotocollib.protocol.data.game.entity.EquipmentSlot;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.Equipment;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;

public class ClientboundSetEquipmentPacket
implements MinecraftPacket {
    private final int entityId;
    @lombok.NonNull
    private final Equipment[] equipment;

    public ClientboundSetEquipmentPacket(ByteBuf in) {
        this.entityId = MinecraftTypes.readVarInt(in);
        boolean hasNextEntry = true;
        ArrayList<Equipment> list = new ArrayList<Equipment>();
        while (hasNextEntry) {
            byte rawSlot = in.readByte();
            EquipmentSlot slot = EquipmentSlot.fromEnumOrdinal(rawSlot & 0x7F);
            ItemStack item = MinecraftTypes.readOptionalItemStack(in);
            list.add(new Equipment(slot, item));
            hasNextEntry = (rawSlot & 0x80) == 128;
        }
        this.equipment = list.toArray(new Equipment[0]);
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeVarInt(out, this.entityId);
        for (int i = 0; i < this.equipment.length; ++i) {
            int rawSlot = this.equipment[i].getSlot().ordinal();
            if (i != this.equipment.length - 1) {
                rawSlot |= 0x80;
            }
            out.writeByte(rawSlot);
            MinecraftTypes.writeOptionalItemStack(out, this.equipment[i].getItem());
        }
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public int getEntityId() {
        return this.entityId;
    }

    @lombok.NonNull
    public Equipment[] getEquipment() {
        return this.equipment;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSetEquipmentPacket)) {
            return false;
        }
        ClientboundSetEquipmentPacket other = (ClientboundSetEquipmentPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        return Arrays.deepEquals(this.getEquipment(), other.getEquipment());
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundSetEquipmentPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        result = result * 59 + Arrays.deepHashCode(this.getEquipment());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundSetEquipmentPacket(entityId=" + this.getEntityId() + ", equipment=" + Arrays.deepToString(this.getEquipment()) + ")";
    }

    public @NonNull ClientboundSetEquipmentPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ClientboundSetEquipmentPacket(entityId, this.equipment);
    }

    public @NonNull ClientboundSetEquipmentPacket withEquipment(@lombok.NonNull Equipment[] equipment) {
        if (equipment == null) {
            throw new NullPointerException("equipment is marked non-null but is null");
        }
        return this.equipment == equipment ? this : new ClientboundSetEquipmentPacket(this.entityId, equipment);
    }

    public ClientboundSetEquipmentPacket(int entityId, @lombok.NonNull Equipment[] equipment) {
        if (equipment == null) {
            throw new NullPointerException("equipment is marked non-null but is null");
        }
        this.entityId = entityId;
        this.equipment = equipment;
    }
}

