/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.debug;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.geysermc.mcprotocollib.protocol.data.game.debug.DebugInfo;
import org.geysermc.mcprotocollib.protocol.data.game.debug.DebugSubscriptions;
import org.jetbrains.annotations.Nullable;

public class ClientboundDebugChunkValuePacket
implements MinecraftPacket {
    private final int chunkX;
    private final int chunkZ;
    private final DebugSubscriptions subscriptionType;
    @Nullable
    private final DebugInfo subscription;

    public ClientboundDebugChunkValuePacket(ByteBuf in) {
        long chunkPos = in.readLong();
        this.chunkX = (int)chunkPos;
        this.chunkZ = (int)(chunkPos >> 32);
        this.subscriptionType = DebugSubscriptions.from(MinecraftTypes.readVarInt(in));
        this.subscription = MinecraftTypes.readDebugSubscriptionUpdate(in, this.subscriptionType);
    }

    @Override
    public void serialize(ByteBuf out) {
        out.writeLong((long)this.chunkX & 0xFFFFFFFFL | ((long)this.chunkZ & 0xFFFFFFFFL) << 32);
        MinecraftTypes.writeVarInt(out, this.subscriptionType.ordinal());
        MinecraftTypes.writeDebugSubscriptionUpdate(out, this.subscriptionType, this.subscription);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public int getChunkX() {
        return this.chunkX;
    }

    public int getChunkZ() {
        return this.chunkZ;
    }

    public DebugSubscriptions getSubscriptionType() {
        return this.subscriptionType;
    }

    @Nullable
    public DebugInfo getSubscription() {
        return this.subscription;
    }

    public boolean equals(@org.checkerframework.checker.nullness.qual.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundDebugChunkValuePacket)) {
            return false;
        }
        ClientboundDebugChunkValuePacket other = (ClientboundDebugChunkValuePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getChunkX() != other.getChunkX()) {
            return false;
        }
        if (this.getChunkZ() != other.getChunkZ()) {
            return false;
        }
        DebugSubscriptions this$subscriptionType = this.getSubscriptionType();
        DebugSubscriptions other$subscriptionType = other.getSubscriptionType();
        if (this$subscriptionType == null ? other$subscriptionType != null : !((Object)((Object)this$subscriptionType)).equals((Object)other$subscriptionType)) {
            return false;
        }
        DebugInfo this$subscription = this.getSubscription();
        DebugInfo other$subscription = other.getSubscription();
        return !(this$subscription == null ? other$subscription != null : !this$subscription.equals(other$subscription));
    }

    protected boolean canEqual(@org.checkerframework.checker.nullness.qual.Nullable Object other) {
        return other instanceof ClientboundDebugChunkValuePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getChunkX();
        result = result * 59 + this.getChunkZ();
        DebugSubscriptions $subscriptionType = this.getSubscriptionType();
        result = result * 59 + ($subscriptionType == null ? 43 : ((Object)((Object)$subscriptionType)).hashCode());
        DebugInfo $subscription = this.getSubscription();
        result = result * 59 + ($subscription == null ? 43 : $subscription.hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundDebugChunkValuePacket(chunkX=" + this.getChunkX() + ", chunkZ=" + this.getChunkZ() + ", subscriptionType=" + String.valueOf((Object)this.getSubscriptionType()) + ", subscription=" + String.valueOf(this.getSubscription()) + ")";
    }

    public @NonNull ClientboundDebugChunkValuePacket withChunkX(int chunkX) {
        return this.chunkX == chunkX ? this : new ClientboundDebugChunkValuePacket(chunkX, this.chunkZ, this.subscriptionType, this.subscription);
    }

    public @NonNull ClientboundDebugChunkValuePacket withChunkZ(int chunkZ) {
        return this.chunkZ == chunkZ ? this : new ClientboundDebugChunkValuePacket(this.chunkX, chunkZ, this.subscriptionType, this.subscription);
    }

    public @NonNull ClientboundDebugChunkValuePacket withSubscriptionType(DebugSubscriptions subscriptionType) {
        return this.subscriptionType == subscriptionType ? this : new ClientboundDebugChunkValuePacket(this.chunkX, this.chunkZ, subscriptionType, this.subscription);
    }

    public @NonNull ClientboundDebugChunkValuePacket withSubscription(@Nullable DebugInfo subscription) {
        return this.subscription == subscription ? this : new ClientboundDebugChunkValuePacket(this.chunkX, this.chunkZ, this.subscriptionType, subscription);
    }

    public ClientboundDebugChunkValuePacket(int chunkX, int chunkZ, DebugSubscriptions subscriptionType, @Nullable DebugInfo subscription) {
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.subscriptionType = subscriptionType;
        this.subscription = subscription;
    }
}

