/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound;

import io.netty.buffer.ByteBuf;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;

public class ClientboundSystemChatPacket
implements MinecraftPacket {
    private final Component content;
    private final boolean overlay;

    public ClientboundSystemChatPacket(ByteBuf in) {
        this.content = MinecraftTypes.readComponent(in);
        this.overlay = in.readBoolean();
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeComponent(out, this.content);
        out.writeBoolean(this.overlay);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public Component getContent() {
        return this.content;
    }

    public boolean isOverlay() {
        return this.overlay;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSystemChatPacket)) {
            return false;
        }
        ClientboundSystemChatPacket other = (ClientboundSystemChatPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isOverlay() != other.isOverlay()) {
            return false;
        }
        Component this$content = this.getContent();
        Component other$content = other.getContent();
        return !(this$content == null ? other$content != null : !this$content.equals(other$content));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundSystemChatPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isOverlay() ? 79 : 97);
        Component $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundSystemChatPacket(content=" + String.valueOf(this.getContent()) + ", overlay=" + this.isOverlay() + ")";
    }

    public @NonNull ClientboundSystemChatPacket withContent(Component content) {
        return this.content == content ? this : new ClientboundSystemChatPacket(content, this.overlay);
    }

    public @NonNull ClientboundSystemChatPacket withOverlay(boolean overlay) {
        return this.overlay == overlay ? this : new ClientboundSystemChatPacket(this.content, overlay);
    }

    public ClientboundSystemChatPacket(Component content, boolean overlay) {
        this.content = content;
        this.overlay = overlay;
    }
}

