/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.configuration.clientbound;

import io.netty.buffer.ByteBuf;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.geysermc.mcprotocollib.protocol.data.game.KnownPack;

public class ClientboundSelectKnownPacks
implements MinecraftPacket {
    private final List<KnownPack> knownPacks;

    public ClientboundSelectKnownPacks(ByteBuf in) {
        this.knownPacks = MinecraftTypes.readList(in, buf -> new KnownPack(MinecraftTypes.readString(buf), MinecraftTypes.readString(buf), MinecraftTypes.readString(buf)));
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeList(out, this.knownPacks, (buf, entry) -> {
            MinecraftTypes.writeString(buf, entry.getNamespace());
            MinecraftTypes.writeString(buf, entry.getId());
            MinecraftTypes.writeString(buf, entry.getVersion());
        });
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public List<KnownPack> getKnownPacks() {
        return this.knownPacks;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSelectKnownPacks)) {
            return false;
        }
        ClientboundSelectKnownPacks other = (ClientboundSelectKnownPacks)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<KnownPack> this$knownPacks = this.getKnownPacks();
        List<KnownPack> other$knownPacks = other.getKnownPacks();
        return !(this$knownPacks == null ? other$knownPacks != null : !((Object)this$knownPacks).equals(other$knownPacks));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundSelectKnownPacks;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<KnownPack> $knownPacks = this.getKnownPacks();
        result = result * 59 + ($knownPacks == null ? 43 : ((Object)$knownPacks).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundSelectKnownPacks(knownPacks=" + String.valueOf(this.getKnownPacks()) + ")";
    }

    public @NonNull ClientboundSelectKnownPacks withKnownPacks(List<KnownPack> knownPacks) {
        return this.knownPacks == knownPacks ? this : new ClientboundSelectKnownPacks(knownPacks);
    }

    public ClientboundSelectKnownPacks(List<KnownPack> knownPacks) {
        this.knownPacks = knownPacks;
    }
}

