/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.common.serverbound;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.HandPreference;
import org.geysermc.mcprotocollib.protocol.data.game.setting.ChatVisibility;
import org.geysermc.mcprotocollib.protocol.data.game.setting.ParticleStatus;
import org.geysermc.mcprotocollib.protocol.data.game.setting.SkinPart;

public class ServerboundClientInformationPacket
implements MinecraftPacket {
    @lombok.NonNull
    private final String locale;
    private final int renderDistance;
    @lombok.NonNull
    private final ChatVisibility chatVisibility;
    private final boolean useChatColors;
    @lombok.NonNull
    private final List<SkinPart> visibleParts;
    @lombok.NonNull
    private final HandPreference mainHand;
    private final boolean textFilteringEnabled;
    private final boolean allowsListing;
    @lombok.NonNull
    private final ParticleStatus particleStatus;

    public ServerboundClientInformationPacket(ByteBuf in) {
        this.locale = MinecraftTypes.readString(in);
        this.renderDistance = in.readByte();
        this.chatVisibility = ChatVisibility.from(MinecraftTypes.readVarInt(in));
        this.useChatColors = in.readBoolean();
        this.visibleParts = new ArrayList<SkinPart>();
        short flags = in.readUnsignedByte();
        for (SkinPart part : SkinPart.VALUES) {
            int bit = 1 << part.ordinal();
            if ((flags & bit) != bit) continue;
            this.visibleParts.add(part);
        }
        this.mainHand = HandPreference.from(MinecraftTypes.readVarInt(in));
        this.textFilteringEnabled = in.readBoolean();
        this.allowsListing = in.readBoolean();
        this.particleStatus = ParticleStatus.from(MinecraftTypes.readVarInt(in));
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeString(out, this.locale);
        out.writeByte(this.renderDistance);
        MinecraftTypes.writeVarInt(out, this.chatVisibility.ordinal());
        out.writeBoolean(this.useChatColors);
        int flags = 0;
        for (SkinPart part : this.visibleParts) {
            flags |= 1 << part.ordinal();
        }
        out.writeByte(flags);
        MinecraftTypes.writeVarInt(out, this.mainHand.ordinal());
        out.writeBoolean(this.textFilteringEnabled);
        out.writeBoolean(this.allowsListing);
        MinecraftTypes.writeVarInt(out, this.particleStatus.ordinal());
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return false;
    }

    @lombok.NonNull
    public String getLocale() {
        return this.locale;
    }

    public int getRenderDistance() {
        return this.renderDistance;
    }

    @lombok.NonNull
    public ChatVisibility getChatVisibility() {
        return this.chatVisibility;
    }

    public boolean isUseChatColors() {
        return this.useChatColors;
    }

    @lombok.NonNull
    public List<SkinPart> getVisibleParts() {
        return this.visibleParts;
    }

    @lombok.NonNull
    public HandPreference getMainHand() {
        return this.mainHand;
    }

    public boolean isTextFilteringEnabled() {
        return this.textFilteringEnabled;
    }

    public boolean isAllowsListing() {
        return this.allowsListing;
    }

    @lombok.NonNull
    public ParticleStatus getParticleStatus() {
        return this.particleStatus;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundClientInformationPacket)) {
            return false;
        }
        ServerboundClientInformationPacket other = (ServerboundClientInformationPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRenderDistance() != other.getRenderDistance()) {
            return false;
        }
        if (this.isUseChatColors() != other.isUseChatColors()) {
            return false;
        }
        if (this.isTextFilteringEnabled() != other.isTextFilteringEnabled()) {
            return false;
        }
        if (this.isAllowsListing() != other.isAllowsListing()) {
            return false;
        }
        String this$locale = this.getLocale();
        String other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !this$locale.equals(other$locale)) {
            return false;
        }
        ChatVisibility this$chatVisibility = this.getChatVisibility();
        ChatVisibility other$chatVisibility = other.getChatVisibility();
        if (this$chatVisibility == null ? other$chatVisibility != null : !((Object)((Object)this$chatVisibility)).equals((Object)other$chatVisibility)) {
            return false;
        }
        List<SkinPart> this$visibleParts = this.getVisibleParts();
        List<SkinPart> other$visibleParts = other.getVisibleParts();
        if (this$visibleParts == null ? other$visibleParts != null : !((Object)this$visibleParts).equals(other$visibleParts)) {
            return false;
        }
        HandPreference this$mainHand = this.getMainHand();
        HandPreference other$mainHand = other.getMainHand();
        if (this$mainHand == null ? other$mainHand != null : !((Object)((Object)this$mainHand)).equals((Object)other$mainHand)) {
            return false;
        }
        ParticleStatus this$particleStatus = this.getParticleStatus();
        ParticleStatus other$particleStatus = other.getParticleStatus();
        return !(this$particleStatus == null ? other$particleStatus != null : !((Object)((Object)this$particleStatus)).equals((Object)other$particleStatus));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundClientInformationPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRenderDistance();
        result = result * 59 + (this.isUseChatColors() ? 79 : 97);
        result = result * 59 + (this.isTextFilteringEnabled() ? 79 : 97);
        result = result * 59 + (this.isAllowsListing() ? 79 : 97);
        String $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : $locale.hashCode());
        ChatVisibility $chatVisibility = this.getChatVisibility();
        result = result * 59 + ($chatVisibility == null ? 43 : ((Object)((Object)$chatVisibility)).hashCode());
        List<SkinPart> $visibleParts = this.getVisibleParts();
        result = result * 59 + ($visibleParts == null ? 43 : ((Object)$visibleParts).hashCode());
        HandPreference $mainHand = this.getMainHand();
        result = result * 59 + ($mainHand == null ? 43 : ((Object)((Object)$mainHand)).hashCode());
        ParticleStatus $particleStatus = this.getParticleStatus();
        result = result * 59 + ($particleStatus == null ? 43 : ((Object)((Object)$particleStatus)).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ServerboundClientInformationPacket(locale=" + this.getLocale() + ", renderDistance=" + this.getRenderDistance() + ", chatVisibility=" + String.valueOf((Object)this.getChatVisibility()) + ", useChatColors=" + this.isUseChatColors() + ", visibleParts=" + String.valueOf(this.getVisibleParts()) + ", mainHand=" + String.valueOf((Object)this.getMainHand()) + ", textFilteringEnabled=" + this.isTextFilteringEnabled() + ", allowsListing=" + this.isAllowsListing() + ", particleStatus=" + String.valueOf((Object)this.getParticleStatus()) + ")";
    }

    public @NonNull ServerboundClientInformationPacket withLocale(@lombok.NonNull String locale) {
        if (locale == null) {
            throw new NullPointerException("locale is marked non-null but is null");
        }
        return this.locale == locale ? this : new ServerboundClientInformationPacket(locale, this.renderDistance, this.chatVisibility, this.useChatColors, this.visibleParts, this.mainHand, this.textFilteringEnabled, this.allowsListing, this.particleStatus);
    }

    public @NonNull ServerboundClientInformationPacket withRenderDistance(int renderDistance) {
        return this.renderDistance == renderDistance ? this : new ServerboundClientInformationPacket(this.locale, renderDistance, this.chatVisibility, this.useChatColors, this.visibleParts, this.mainHand, this.textFilteringEnabled, this.allowsListing, this.particleStatus);
    }

    public @NonNull ServerboundClientInformationPacket withChatVisibility(@lombok.NonNull ChatVisibility chatVisibility) {
        if (chatVisibility == null) {
            throw new NullPointerException("chatVisibility is marked non-null but is null");
        }
        return this.chatVisibility == chatVisibility ? this : new ServerboundClientInformationPacket(this.locale, this.renderDistance, chatVisibility, this.useChatColors, this.visibleParts, this.mainHand, this.textFilteringEnabled, this.allowsListing, this.particleStatus);
    }

    public @NonNull ServerboundClientInformationPacket withUseChatColors(boolean useChatColors) {
        return this.useChatColors == useChatColors ? this : new ServerboundClientInformationPacket(this.locale, this.renderDistance, this.chatVisibility, useChatColors, this.visibleParts, this.mainHand, this.textFilteringEnabled, this.allowsListing, this.particleStatus);
    }

    public @NonNull ServerboundClientInformationPacket withVisibleParts(@lombok.NonNull List<SkinPart> visibleParts) {
        if (visibleParts == null) {
            throw new NullPointerException("visibleParts is marked non-null but is null");
        }
        return this.visibleParts == visibleParts ? this : new ServerboundClientInformationPacket(this.locale, this.renderDistance, this.chatVisibility, this.useChatColors, visibleParts, this.mainHand, this.textFilteringEnabled, this.allowsListing, this.particleStatus);
    }

    public @NonNull ServerboundClientInformationPacket withMainHand(@lombok.NonNull HandPreference mainHand) {
        if (mainHand == null) {
            throw new NullPointerException("mainHand is marked non-null but is null");
        }
        return this.mainHand == mainHand ? this : new ServerboundClientInformationPacket(this.locale, this.renderDistance, this.chatVisibility, this.useChatColors, this.visibleParts, mainHand, this.textFilteringEnabled, this.allowsListing, this.particleStatus);
    }

    public @NonNull ServerboundClientInformationPacket withTextFilteringEnabled(boolean textFilteringEnabled) {
        return this.textFilteringEnabled == textFilteringEnabled ? this : new ServerboundClientInformationPacket(this.locale, this.renderDistance, this.chatVisibility, this.useChatColors, this.visibleParts, this.mainHand, textFilteringEnabled, this.allowsListing, this.particleStatus);
    }

    public @NonNull ServerboundClientInformationPacket withAllowsListing(boolean allowsListing) {
        return this.allowsListing == allowsListing ? this : new ServerboundClientInformationPacket(this.locale, this.renderDistance, this.chatVisibility, this.useChatColors, this.visibleParts, this.mainHand, this.textFilteringEnabled, allowsListing, this.particleStatus);
    }

    public @NonNull ServerboundClientInformationPacket withParticleStatus(@lombok.NonNull ParticleStatus particleStatus) {
        if (particleStatus == null) {
            throw new NullPointerException("particleStatus is marked non-null but is null");
        }
        return this.particleStatus == particleStatus ? this : new ServerboundClientInformationPacket(this.locale, this.renderDistance, this.chatVisibility, this.useChatColors, this.visibleParts, this.mainHand, this.textFilteringEnabled, this.allowsListing, particleStatus);
    }

    public ServerboundClientInformationPacket(@lombok.NonNull String locale, int renderDistance, @lombok.NonNull ChatVisibility chatVisibility, boolean useChatColors, @lombok.NonNull List<SkinPart> visibleParts, @lombok.NonNull HandPreference mainHand, boolean textFilteringEnabled, boolean allowsListing, @lombok.NonNull ParticleStatus particleStatus) {
        if (locale == null) {
            throw new NullPointerException("locale is marked non-null but is null");
        }
        if (chatVisibility == null) {
            throw new NullPointerException("chatVisibility is marked non-null but is null");
        }
        if (visibleParts == null) {
            throw new NullPointerException("visibleParts is marked non-null but is null");
        }
        if (mainHand == null) {
            throw new NullPointerException("mainHand is marked non-null but is null");
        }
        if (particleStatus == null) {
            throw new NullPointerException("particleStatus is marked non-null but is null");
        }
        this.locale = locale;
        this.renderDistance = renderDistance;
        this.chatVisibility = chatVisibility;
        this.useChatColors = useChatColors;
        this.visibleParts = visibleParts;
        this.mainHand = mainHand;
        this.textFilteringEnabled = textFilteringEnabled;
        this.allowsListing = allowsListing;
        this.particleStatus = particleStatus;
    }
}

