/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.level.particle;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.data.game.level.particle.ParticleData;

public class SpellParticleData
implements ParticleData {
    private final int color;
    private final float power;

    public int getColor() {
        return this.color;
    }

    public float getPower() {
        return this.power;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpellParticleData)) {
            return false;
        }
        SpellParticleData other = (SpellParticleData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getColor() != other.getColor()) {
            return false;
        }
        return Float.compare(this.getPower(), other.getPower()) == 0;
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof SpellParticleData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getColor();
        result = result * 59 + Float.floatToIntBits(this.getPower());
        return result;
    }

    public @NonNull String toString() {
        return "SpellParticleData(color=" + this.getColor() + ", power=" + this.getPower() + ")";
    }

    public SpellParticleData(int color, float power) {
        this.color = color;
        this.power = power;
    }
}

