/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.network.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.WriteTimeoutHandler;
import java.util.function.Function;
import org.geysermc.mcprotocollib.network.BuiltinFlags;
import org.geysermc.mcprotocollib.network.Session;
import org.geysermc.mcprotocollib.network.netty.AutoReadFlowControlHandler;
import org.geysermc.mcprotocollib.network.netty.FlushHandler;
import org.geysermc.mcprotocollib.network.netty.PacketCodec;
import org.geysermc.mcprotocollib.network.netty.PacketCompressionCodec;
import org.geysermc.mcprotocollib.network.netty.PacketEncryptorCodec;
import org.geysermc.mcprotocollib.network.netty.PacketSizerCodec;
import org.geysermc.mcprotocollib.protocol.MinecraftProtocol;

public class MinecraftChannelInitializer<S extends Session & ChannelHandler>
extends ChannelInitializer<Channel> {
    private final Function<Channel, S> sessionFactory;
    private final boolean client;

    protected void initChannel(Channel ch) throws Exception {
        S session = this.createSession(ch);
        this.addHandlers(session, ch);
    }

    protected S createSession(Channel ch) {
        return (S)((Session)this.sessionFactory.apply(ch));
    }

    protected void addHandlers(S session, Channel ch) {
        MinecraftProtocol protocol = session.getPacketProtocol();
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast("read-timeout", (ChannelHandler)new ReadTimeoutHandler(session.getFlag(BuiltinFlags.READ_TIMEOUT, 30).intValue()));
        pipeline.addLast("write-timeout", (ChannelHandler)new WriteTimeoutHandler(session.getFlag(BuiltinFlags.WRITE_TIMEOUT, 0).intValue()));
        pipeline.addLast("encryption", (ChannelHandler)new PacketEncryptorCodec());
        pipeline.addLast("sizer", (ChannelHandler)new PacketSizerCodec(protocol.getPacketHeader()));
        pipeline.addLast("compression", (ChannelHandler)new PacketCompressionCodec());
        pipeline.addLast("flow-control", (ChannelHandler)new AutoReadFlowControlHandler());
        pipeline.addLast("codec", (ChannelHandler)new PacketCodec((Session)session, this.client));
        pipeline.addLast("flush-handler", (ChannelHandler)new FlushHandler());
        pipeline.addLast("manager", (ChannelHandler)session);
    }

    public MinecraftChannelInitializer(Function<Channel, S> sessionFactory, boolean client) {
        this.sessionFactory = sessionFactory;
        this.client = client;
    }
}

