/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.auth.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.UUID;
import net.lenni0451.commons.httpclient.HttpClient;
import net.lenni0451.commons.httpclient.HttpResponse;
import net.lenni0451.commons.httpclient.constants.ContentTypes;
import net.lenni0451.commons.httpclient.content.HttpContent;
import net.lenni0451.commons.httpclient.proxy.ProxyHandler;
import net.lenni0451.commons.httpclient.proxy.ProxyType;
import net.lenni0451.commons.httpclient.requests.HttpContentRequest;
import net.lenni0451.commons.httpclient.requests.HttpRequest;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.auth.util.UndashedUUIDAdapter;
import org.geysermc.mcprotocollib.network.ProxyInfo;

public class HTTPUtils {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(UUID.class, (Object)new UndashedUUIDAdapter()).create();

    private HTTPUtils() {
    }

    public static <T> T makeRequest(@Nullable ProxyInfo proxy, URI uri, Object input, Class<T> responseType) throws IOException {
        if (uri == null) {
            throw new IllegalArgumentException("URI cannot be null.");
        }
        HttpResponse response = HTTPUtils.createHttpClient(proxy).execute(input == null ? new HttpRequest("GET", uri.toURL()) : (HttpRequest)new HttpContentRequest("POST", uri.toURL()).setContent(HttpContent.string((String)GSON.toJson(input))).setHeader("Content-Type", ContentTypes.APPLICATION_JSON.toString()));
        if (responseType == null) {
            return null;
        }
        return (T)GSON.fromJson((Reader)new InputStreamReader(response.getContent().getAsStream()), responseType);
    }

    public static HttpClient createHttpClient(@Nullable ProxyInfo proxy) {
        int timeout = 5000;
        HttpClient client = (HttpClient)((HttpClient)new HttpClient().setConnectTimeout(5000).setReadTimeout(10000).setCookieManager(null).setFollowRedirects(false).setHeader("Accept", ContentTypes.APPLICATION_JSON.toString())).setHeader("Accept-Language", "en-US,en");
        if (proxy != null) {
            client.setProxyHandler(new ProxyHandler(switch (proxy.type()) {
                default -> throw new IncompatibleClassChangeError();
                case ProxyInfo.Type.HTTP -> ProxyType.HTTP;
                case ProxyInfo.Type.SOCKS4 -> ProxyType.SOCKS4;
                case ProxyInfo.Type.SOCKS5 -> ProxyType.SOCKS5;
            }, proxy.address(), proxy.username(), proxy.password()));
        }
        return client;
    }
}

