/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.event.bedrock.SessionAcceptCodeOfConductEvent;
import org.geysermc.geyser.api.event.java.ServerCodeOfConductEvent;
import org.geysermc.geyser.session.GeyserSession;

public class CodeOfConductManager {
    private static final Path SAVE_PATH = Path.of("cache/codeofconducts.json", new String[0]);
    private static CodeOfConductManager loaded = null;
    private final Object2IntMap<String> playerAcceptedCodeOfConducts = new Object2IntOpenHashMap();
    private boolean dirty = false;

    private CodeOfConductManager() {
        Path savePath = CodeOfConductManager.getSavePath();
        if (Files.exists(savePath, new LinkOption[0]) && Files.isRegularFile(savePath, new LinkOption[0])) {
            GeyserImpl.getInstance().getLogger().debug("Loading codeofconducts.json");
            try (FileReader reader = new FileReader(savePath.toFile());){
                JsonObject object = new JsonParser().parse((Reader)reader).getAsJsonObject();
                for (Map.Entry entry : object.entrySet()) {
                    this.playerAcceptedCodeOfConducts.put((Object)((String)entry.getKey()), ((JsonElement)entry.getValue()).getAsInt());
                }
            }
            catch (IOException exception) {
                GeyserImpl.getInstance().getLogger().error("Failed to read code of conduct cache!", exception);
            }
        } else {
            GeyserImpl.getInstance().getLogger().debug("codeofconducts.json not found, not loading");
        }
        GeyserImpl.getInstance().getScheduledThread().scheduleAtFixedRate(this::save, 0L, 5L, TimeUnit.MINUTES);
    }

    public boolean hasAcceptedCodeOfConduct(GeyserSession session, String codeOfConduct) {
        ServerCodeOfConductEvent event = new ServerCodeOfConductEvent(session, codeOfConduct);
        session.getGeyser().getEventBus().fire(event);
        return event.accepted() || this.playerAcceptedCodeOfConducts.getInt((Object)session.xuid()) == codeOfConduct.hashCode();
    }

    public void saveCodeOfConductAccepted(GeyserSession session, String codeOfConduct) {
        SessionAcceptCodeOfConductEvent event = new SessionAcceptCodeOfConductEvent(session, codeOfConduct);
        session.getGeyser().getEventBus().fire(event);
        if (!event.shouldSkipSaving()) {
            this.playerAcceptedCodeOfConducts.put((Object)session.xuid(), codeOfConduct.hashCode());
            this.dirty = true;
        }
    }

    public static void trySave() {
        if (loaded == null) {
            return;
        }
        CodeOfConductManager.getInstance().save();
    }

    public void save() {
        if (this.dirty) {
            GeyserImpl.getInstance().getLogger().debug("Saving codeofconducts.json");
            JsonObject saved = new JsonObject();
            this.playerAcceptedCodeOfConducts.forEach((arg_0, arg_1) -> ((JsonObject)saved).addProperty(arg_0, arg_1));
            try {
                Files.writeString(CodeOfConductManager.getSavePath(), (CharSequence)saved.toString(), new OpenOption[0]);
                this.dirty = false;
            }
            catch (IOException exception) {
                GeyserImpl.getInstance().getLogger().error("Failed to write code of conduct cache!", exception);
            }
        }
    }

    private static Path getSavePath() {
        return GeyserImpl.getInstance().configDirectory().resolve(SAVE_PATH);
    }

    public static void load() {
        if (loaded == null) {
            loaded = new CodeOfConductManager();
        }
    }

    public static CodeOfConductManager getInstance() {
        if (loaded == null) {
            throw new IllegalStateException("CodeOfConductManager was accessed before loaded");
        }
        return loaded;
    }
}

