/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.entity;

import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.Leashable;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityEventType;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.EntityEventPacket;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity.ClientboundSetEntityLinkPacket;

@Translator(packet=ClientboundSetEntityLinkPacket.class)
public class JavaSetEntityLinkTranslator
extends PacketTranslator<ClientboundSetEntityLinkPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundSetEntityLinkPacket packet) {
        Entity holderId = session.getEntityCache().getEntityByJavaId(packet.getEntityId());
        if (!(holderId instanceof Leashable)) {
            return;
        }
        Leashable asLeashable = (Leashable)((Object)holderId);
        Entity attachedToId = session.getEntityCache().getEntityByJavaId(packet.getAttachedToId());
        if (attachedToId == null || packet.getAttachedToId() == 0) {
            holderId.setFlag(EntityFlag.LEASHED, false);
            asLeashable.setLeashHolderBedrockId(-1L);
            holderId.updateBedrockMetadata();
            EntityEventPacket eventPacket = new EntityEventPacket();
            eventPacket.setRuntimeEntityId(holderId.geyserId());
            eventPacket.setType(EntityEventType.REMOVE_LEASH);
            eventPacket.setData(0);
            session.sendUpstreamPacket(eventPacket);
            return;
        }
        holderId.setFlag(EntityFlag.LEASHED, true);
        asLeashable.setLeashHolderBedrockId(attachedToId.geyserId());
        holderId.updateBedrockMetadata();
    }
}

