/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.entity;

import java.util.Collections;
import java.util.concurrent.ThreadLocalRandom;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.EvokerFangsEntity;
import org.geysermc.geyser.entity.type.FishingHookEntity;
import org.geysermc.geyser.entity.type.LivingEntity;
import org.geysermc.geyser.entity.type.ThrowableEggEntity;
import org.geysermc.geyser.entity.type.living.animal.ArmadilloEntity;
import org.geysermc.geyser.entity.type.living.monster.CreakingEntity;
import org.geysermc.geyser.entity.type.living.monster.WardenEntity;
import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.ParticleType;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.SoundEvent;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityEventType;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.EntityEventPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.InventoryContentPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.LevelEventPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.LevelSoundEventPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.PlaySoundPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.SetEntityDataPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.SetEntityMotionPacket;
import org.geysermc.geyser.translator.item.ItemTranslator;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.InventoryUtils;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity.ClientboundEntityEventPacket;

@Translator(packet=ClientboundEntityEventPacket.class)
public class JavaEntityEventTranslator
extends PacketTranslator<ClientboundEntityEventPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundEntityEventPacket packet) {
        Entity entity = session.getEntityCache().getEntityByJavaId(packet.getEntityId());
        if (entity == null) {
            return;
        }
        EntityEventPacket entityEventPacket = new EntityEventPacket();
        entityEventPacket.setRuntimeEntityId(entity.geyserId());
        switch (packet.getEvent()) {
            case PLAYER_ENABLE_REDUCED_DEBUG: {
                session.setReducedDebugInfo(true);
                return;
            }
            case PLAYER_DISABLE_REDUCED_DEBUG: {
                session.setReducedDebugInfo(false);
                return;
            }
            case PLAYER_OP_PERMISSION_LEVEL_0: {
                session.setOpPermissionLevel(0);
                session.sendAdventureSettings();
                return;
            }
            case PLAYER_OP_PERMISSION_LEVEL_1: {
                session.setOpPermissionLevel(1);
                session.sendAdventureSettings();
                return;
            }
            case PLAYER_OP_PERMISSION_LEVEL_2: {
                session.setOpPermissionLevel(2);
                session.sendAdventureSettings();
                return;
            }
            case PLAYER_OP_PERMISSION_LEVEL_3: {
                session.setOpPermissionLevel(3);
                session.sendAdventureSettings();
                return;
            }
            case PLAYER_OP_PERMISSION_LEVEL_4: {
                session.setOpPermissionLevel(4);
                session.sendAdventureSettings();
                return;
            }
            case LIVING_DEATH: {
                entityEventPacket.setType(EntityEventType.DEATH);
                if (entity instanceof ThrowableEggEntity) {
                    ThrowableEggEntity egg = (ThrowableEggEntity)entity;
                    LevelEventPacket particlePacket = new LevelEventPacket();
                    particlePacket.setType(ParticleType.ICON_CRACK);
                    particlePacket.setData(ItemTranslator.getBedrockItemDefinition(session, egg.getItemStack()).getRuntimeId() << 16);
                    particlePacket.setPosition(entity.getPosition());
                    for (int i = 0; i < 6; ++i) {
                        session.sendUpstreamPacket(particlePacket);
                    }
                } else {
                    if (entity.getDefinition() != EntityDefinitions.SNOWBALL) break;
                    LevelEventPacket particlePacket = new LevelEventPacket();
                    particlePacket.setType(ParticleType.SNOWBALL_POOF);
                    particlePacket.setPosition(entity.getPosition());
                    for (int i = 0; i < 8; ++i) {
                        session.sendUpstreamPacket(particlePacket);
                    }
                }
                break;
            }
            case WOLF_SHAKE_WATER: {
                entityEventPacket.setType(EntityEventType.SHAKE_WETNESS);
                break;
            }
            case PLAYER_FINISH_USING_ITEM: {
                if (entity instanceof SessionPlayerEntity) {
                    entity.setFlag(EntityFlag.USING_ITEM, false);
                }
                entityEventPacket.setType(EntityEventType.USE_ITEM);
                break;
            }
            case FISHING_HOOK_PULL_PLAYER: {
                Entity hookOwner;
                FishingHookEntity fishingHook = (FishingHookEntity)entity;
                if (fishingHook.getBedrockTargetId() == session.getPlayerEntity().geyserId() && (hookOwner = session.getEntityCache().getEntityByGeyserId(fishingHook.getBedrockOwnerId())) != null) {
                    SetEntityMotionPacket motionPacket = new SetEntityMotionPacket();
                    motionPacket.setRuntimeEntityId(session.getPlayerEntity().geyserId());
                    motionPacket.setMotion(hookOwner.getPosition().sub(session.getPlayerEntity().getPosition()).mul(0.1f));
                    session.sendUpstreamPacket(motionPacket);
                }
                return;
            }
            case TAMEABLE_TAMING_FAILED: {
                entityEventPacket.setType(EntityEventType.TAME_FAILED);
                break;
            }
            case TAMEABLE_TAMING_SUCCEEDED: {
                entityEventPacket.setType(EntityEventType.TAME_SUCCEEDED);
                break;
            }
            case ZOMBIE_VILLAGER_CURE: {
                LevelSoundEventPacket soundPacket = new LevelSoundEventPacket();
                soundPacket.setSound(SoundEvent.REMEDY);
                soundPacket.setPosition(entity.getPosition());
                soundPacket.setExtraData(-1);
                soundPacket.setIdentifier("");
                soundPacket.setRelativeVolumeDisabled(false);
                session.sendUpstreamPacket(soundPacket);
                return;
            }
            case VILLAGER_MATE: 
            case ANIMAL_EMIT_HEARTS: {
                entityEventPacket.setType(EntityEventType.LOVE_PARTICLES);
                break;
            }
            case FIREWORK_EXPLODE: {
                entityEventPacket.setType(EntityEventType.FIREWORK_EXPLODE);
                break;
            }
            case WITCH_EMIT_PARTICLES: {
                entityEventPacket.setType(EntityEventType.WITCH_HAT_MAGIC);
                break;
            }
            case TOTEM_OF_UNDYING_MAKE_SOUND: {
                boolean totemItemWorkaround;
                boolean bl = totemItemWorkaround = !session.getPlayerInventory().isHolding(Items.TOTEM_OF_UNDYING);
                if (totemItemWorkaround) {
                    InventoryContentPacket offhandPacket = new InventoryContentPacket();
                    offhandPacket.setContainerId(119);
                    offhandPacket.setContents(Collections.singletonList(InventoryUtils.getTotemOfUndying().apply(session.getUpstream().getProtocolVersion())));
                    session.sendUpstreamPacket(offhandPacket);
                }
                entityEventPacket.setType(EntityEventType.CONSUME_TOTEM);
                PlaySoundPacket playSoundPacket = new PlaySoundPacket();
                playSoundPacket.setSound("random.totem");
                playSoundPacket.setPosition(entity.getPosition());
                playSoundPacket.setVolume(1.0f);
                playSoundPacket.setPitch(1.0f + ThreadLocalRandom.current().nextFloat() * 0.1f - 0.05f);
                session.sendUpstreamPacket(playSoundPacket);
                session.sendUpstreamPacket(entityEventPacket);
                if (totemItemWorkaround) {
                    session.getPlayerInventoryHolder().updateSlot(45);
                }
                return;
            }
            case SHEEP_GRAZE_OR_TNT_CART_EXPLODE: {
                if (entity.getDefinition() == EntityDefinitions.SHEEP) {
                    entityEventPacket.setType(EntityEventType.EAT_GRASS);
                    break;
                }
                entityEventPacket.setType(EntityEventType.PRIME_TNT_MINECART);
                break;
            }
            case IRON_GOLEM_HOLD_POPPY: {
                entityEventPacket.setType(EntityEventType.GOLEM_FLOWER_OFFER);
                break;
            }
            case VILLAGER_ANGRY: {
                entityEventPacket.setType(EntityEventType.VILLAGER_ANGRY);
                break;
            }
            case VILLAGER_HAPPY: {
                entityEventPacket.setType(EntityEventType.VILLAGER_HAPPY);
                break;
            }
            case VILLAGER_SWEAT: {
                LevelEventPacket levelEventPacket = new LevelEventPacket();
                levelEventPacket.setType(ParticleType.WATER_SPLASH);
                levelEventPacket.setPosition(entity.getPosition().up(entity.getDefinition().height()));
                session.sendUpstreamPacket(levelEventPacket);
                return;
            }
            case IRON_GOLEM_EMPTY_HAND: {
                entityEventPacket.setType(EntityEventType.GOLEM_FLOWER_WITHDRAW);
                break;
            }
            case ATTACK: {
                if (entity.getDefinition() != EntityDefinitions.IRON_GOLEM && entity.getDefinition() != EntityDefinitions.EVOKER_FANGS && entity.getDefinition() != EntityDefinitions.WARDEN) break;
                entityEventPacket.setType(EntityEventType.ATTACK_START);
                if (entity.getDefinition() != EntityDefinitions.EVOKER_FANGS) break;
                ((EvokerFangsEntity)entity).setAttackStarted();
                break;
            }
            case RABBIT_JUMP_OR_MINECART_SPAWNER_DELAY_RESET: {
                if (entity.getDefinition() != EntityDefinitions.RABBIT) break;
                SetEntityDataPacket dataPacket = new SetEntityDataPacket();
                dataPacket.getMetadata().put(EntityDataTypes.JUMP_DURATION, (Object)3);
                dataPacket.setRuntimeEntityId(entity.geyserId());
                session.sendUpstreamPacket(dataPacket);
                return;
            }
            case LIVING_EQUIPMENT_BREAK_HEAD: 
            case LIVING_EQUIPMENT_BREAK_CHEST: 
            case LIVING_EQUIPMENT_BREAK_LEGS: 
            case LIVING_EQUIPMENT_BREAK_FEET: 
            case LIVING_EQUIPMENT_BREAK_MAIN_HAND: 
            case LIVING_EQUIPMENT_BREAK_OFF_HAND: {
                LevelSoundEventPacket equipmentBreakPacket = new LevelSoundEventPacket();
                equipmentBreakPacket.setSound(SoundEvent.BREAK);
                equipmentBreakPacket.setPosition(entity.getPosition());
                equipmentBreakPacket.setExtraData(-1);
                equipmentBreakPacket.setIdentifier("");
                session.sendUpstreamPacket(equipmentBreakPacket);
                return;
            }
            case PLAYER_SWAP_SAME_ITEM: {
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    livingEntity.switchHands();
                    livingEntity.updateMainHand();
                    livingEntity.updateOffHand();
                } else {
                    session.getGeyser().getLogger().debug("Got status message to swap hands for a non-living entity.");
                }
                return;
            }
            case GOAT_LOWERING_HEAD: {
                if (entity.getDefinition() != EntityDefinitions.GOAT) break;
                entityEventPacket.setType(EntityEventType.ATTACK_START);
                break;
            }
            case GOAT_STOP_LOWERING_HEAD: {
                if (entity.getDefinition() != EntityDefinitions.GOAT) break;
                entityEventPacket.setType(EntityEventType.ATTACK_STOP);
                break;
            }
            case MAKE_POOF_PARTICLES: {
                if (!(entity instanceof LivingEntity)) break;
                entityEventPacket.setType(EntityEventType.DEATH_SMOKE_CLOUD);
                break;
            }
            case WARDEN_RECEIVE_SIGNAL: {
                if (entity.getDefinition() != EntityDefinitions.WARDEN) break;
                entityEventPacket.setType(EntityEventType.VIBRATION_DETECTED);
                break;
            }
            case WARDEN_SONIC_BOOM: {
                if (!(entity instanceof WardenEntity)) break;
                WardenEntity wardenEntity = (WardenEntity)entity;
                wardenEntity.onSonicBoom();
                break;
            }
            case ARMADILLO_PEEKING: {
                if (!(entity instanceof ArmadilloEntity)) break;
                ArmadilloEntity armadilloEntity = (ArmadilloEntity)entity;
                armadilloEntity.onPeeking();
                break;
            }
            case SHAKE: {
                if (!(entity instanceof CreakingEntity)) break;
                CreakingEntity creakingEntity = (CreakingEntity)entity;
                creakingEntity.createParticleBeam();
                break;
            }
            case SQUID_RESET_ROTATION: {
                break;
            }
            default: {
                GeyserImpl.getInstance().getLogger().debug("unhandled entity event: " + String.valueOf(packet));
            }
        }
        if (entityEventPacket.getType() != null) {
            session.sendUpstreamPacket(entityEventPacket);
        }
    }
}

