/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock.entity.player.input;

import org.cloudburstmc.math.vector.Vector3d;
import org.cloudburstmc.math.vector.Vector3f;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.entity.type.BoatEntity;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.geyser.level.physics.BoundingBox;
import org.geysermc.geyser.level.physics.CollisionResult;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.PlayerAuthInputData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.PlayerAuthInputPacket;
import org.geysermc.geyser.util.MathUtils;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundMovePlayerPosPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundMovePlayerPosRotPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundMovePlayerRotPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundMovePlayerStatusOnlyPacket;

final class BedrockMovePlayer {
    BedrockMovePlayer() {
    }

    static void translate(GeyserSession session, PlayerAuthInputPacket packet) {
        boolean isOnGround;
        boolean onClimbableBlock;
        boolean rotationChanged;
        boolean actualPositionChanged;
        SessionPlayerEntity entity = session.getPlayerEntity();
        if (!session.isSpawned()) {
            return;
        }
        entity.setBedrockInteractRotation(packet.getInteractRotation());
        if (session.getUnconfirmedTeleport() != null) {
            session.confirmTeleport(packet.getPosition().sub(0.0f, EntityDefinitions.PLAYER.offset(), 0.0f));
            return;
        }
        boolean bl = actualPositionChanged = (double)entity.getPosition().distanceSquared(packet.getPosition()) > 4.0E-8;
        if (actualPositionChanged) {
            session.getBookEditCache().checkForSend();
        }
        if (entity.getBedPosition() != null) {
            return;
        }
        float yaw = packet.getRotation().getY();
        float pitch = packet.getRotation().getX();
        float headYaw = packet.getRotation().getY();
        float javaYaw = entity.getJavaYaw() + MathUtils.wrapDegrees(yaw - entity.getJavaYaw());
        boolean hasVehicle = entity.getVehicle() != null;
        boolean positionChangedAndShouldUpdate = !hasVehicle && (session.getInputCache().shouldSendPositionReminder() || actualPositionChanged);
        boolean bl2 = rotationChanged = hasVehicle || entity.getJavaYaw() != javaYaw || entity.getPitch() != pitch;
        if (BedrockMovePlayer.isInvalidNumber(yaw) || BedrockMovePlayer.isInvalidNumber(pitch) || BedrockMovePlayer.isInvalidNumber(headYaw)) {
            return;
        }
        if (entity.isOnGround() && packet.getInputData().contains((Object)PlayerAuthInputData.START_JUMPING)) {
            entity.setLastTickEndVelocity(Vector3f.from((float)entity.getLastTickEndVelocity().getX(), (float)Math.max(entity.getLastTickEndVelocity().getY(), entity.getJumpVelocity()), (float)entity.getLastTickEndVelocity().getZ()));
        }
        if ((onClimbableBlock = entity.isOnClimbableBlock()) && packet.getInputData().contains((Object)PlayerAuthInputData.JUMPING)) {
            entity.setLastTickEndVelocity(Vector3f.from((float)entity.getLastTickEndVelocity().getX(), (float)0.2f, (float)entity.getLastTickEndVelocity().getZ()));
        }
        entity.setCollidingVertically(packet.getInputData().contains((Object)PlayerAuthInputData.VERTICAL_COLLISION));
        if (hasVehicle || session.isNoClip()) {
            isOnGround = false;
        } else {
            boolean bl3 = isOnGround = entity.isCollidingVertically() && entity.getLastTickEndVelocity().getY() < 0.0f;
        }
        if (packet.getPosition().getY() - EntityDefinitions.PLAYER.offset() < (float)(session.getBedrockDimension().minY() - 5)) {
            boolean possibleOnGround = false;
            BoundingBox boundingBox = session.getCollisionManager().getPlayerBoundingBox().clone();
            boundingBox.extend(0.0, packet.getDelta().getY() - 2.0f, 0.0);
            for (Entity other : session.getEntityCache().getEntities().values()) {
                if (!other.getFlag(EntityFlag.COLLIDABLE) || other == entity) continue;
                BoundingBox entityBoundingBox = new BoundingBox(0.0, 0.0, 0.0, other.getBoundingBoxWidth(), other.getBoundingBoxHeight(), other.getBoundingBoxWidth());
                entityBoundingBox.translate(other.getPosition().down(other instanceof BoatEntity ? other.getDefinition().offset() : 0.0f).toDouble());
                if (!entityBoundingBox.checkIntersection(boundingBox)) continue;
                possibleOnGround = true;
                break;
            }
            session.setNoClip(!possibleOnGround);
        }
        boolean horizontalCollision = packet.getInputData().contains((Object)PlayerAuthInputData.HORIZONTAL_COLLISION);
        if (!positionChangedAndShouldUpdate && rotationChanged) {
            ServerboundMovePlayerRotPacket playerRotationPacket = new ServerboundMovePlayerRotPacket(isOnGround, horizontalCollision, javaYaw, pitch);
            entity.setYaw(yaw);
            entity.setJavaYaw(javaYaw);
            entity.setPitch(pitch);
            entity.setHeadYaw(headYaw);
            session.sendDownstreamGamePacket(playerRotationPacket);
            if (hasVehicle) {
                entity.setPositionManual(packet.getPosition());
                session.getSkullCache().updateVisibleSkulls();
            }
        } else if (positionChangedAndShouldUpdate) {
            if (BedrockMovePlayer.isValidMove(session, entity.getPosition(), packet.getPosition())) {
                CollisionResult result = session.getCollisionManager().adjustBedrockPosition(packet.getPosition(), isOnGround, packet.getInputData().contains((Object)PlayerAuthInputData.HANDLE_TELEPORT));
                if (result != null) {
                    Vector3d position = result.correctedMovement();
                    if (!session.getWorldBorder().isPassingIntoBorderBoundaries(position.toFloat(), true)) {
                        MinecraftPacket movePacket;
                        if (rotationChanged) {
                            movePacket = new ServerboundMovePlayerPosRotPacket(isOnGround, horizontalCollision, position.getX(), position.getY(), position.getZ(), javaYaw, pitch);
                            entity.setYaw(yaw);
                            entity.setJavaYaw(javaYaw);
                            entity.setPitch(pitch);
                            entity.setHeadYaw(headYaw);
                        } else {
                            movePacket = new ServerboundMovePlayerPosPacket(isOnGround, horizontalCollision, position.getX(), position.getY(), position.getZ());
                        }
                        entity.setPositionManual(packet.getPosition());
                        session.sendDownstreamGamePacket(movePacket);
                        session.getInputCache().markPositionPacketSent();
                        session.getSkullCache().updateVisibleSkulls();
                    } else {
                        session.getCollisionManager().recalculatePosition();
                    }
                }
            } else {
                session.getGeyser().getLogger().debug("Recalculating position...");
                session.getCollisionManager().recalculatePosition();
            }
        } else if (horizontalCollision != session.getInputCache().lastHorizontalCollision() || isOnGround != entity.isOnGround()) {
            session.sendDownstreamGamePacket(new ServerboundMovePlayerStatusOnlyPacket(isOnGround, horizontalCollision));
        }
        session.getInputCache().setLastHorizontalCollision(horizontalCollision);
        entity.setOnGround(isOnGround);
        entity.setLastTickEndVelocity(packet.getDelta());
        entity.setMotion(packet.getDelta());
        if (entity.getLeftParrot() != null) {
            entity.getLeftParrot().moveAbsoluteRaw(entity.getPosition(), entity.getYaw(), entity.getPitch(), entity.getHeadYaw(), true, false);
        }
        if (entity.getRightParrot() != null) {
            entity.getRightParrot().moveAbsoluteRaw(entity.getPosition(), entity.getYaw(), entity.getPitch(), entity.getHeadYaw(), true, false);
        }
    }

    private static boolean isInvalidNumber(float val) {
        return Float.isNaN(val) || Float.isInfinite(val);
    }

    private static boolean isValidMove(GeyserSession session, Vector3f currentPosition, Vector3f newPosition) {
        if (BedrockMovePlayer.isInvalidNumber(newPosition.getX()) || BedrockMovePlayer.isInvalidNumber(newPosition.getY()) || BedrockMovePlayer.isInvalidNumber(newPosition.getZ())) {
            return false;
        }
        if (currentPosition.distanceSquared(newPosition) > 300.0f) {
            session.getGeyser().getLogger().debug("\u00a7c" + session.bedrockUsername() + " moved too quickly. current position: " + String.valueOf(currentPosition) + ", new position: " + String.valueOf(newPosition));
            return false;
        }
        return true;
    }
}

