/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock.entity.player;

import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.geyser.entity.type.ItemFrameEntity;
import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityEventType;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.EntityEventPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.PlayStatusPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.PlayerActionPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.UpdateAttributesPacket;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.mcprotocollib.protocol.data.game.entity.object.Direction;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.InteractAction;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.PlayerState;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundInteractPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundPlayerCommandPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundUseItemOnPacket;

@Translator(packet=PlayerActionPacket.class)
public class BedrockPlayerActionTranslator
extends PacketTranslator<PlayerActionPacket> {
    @Override
    public void translate(GeyserSession session, PlayerActionPacket packet) {
        switch (packet.getAction()) {
            case RESPAWN: {
                SessionPlayerEntity entity = session.getPlayerEntity();
                EntityEventPacket eventPacket = new EntityEventPacket();
                eventPacket.setRuntimeEntityId(entity.geyserId());
                eventPacket.setType(EntityEventType.RESPAWN);
                eventPacket.setData(0);
                session.sendUpstreamPacket(eventPacket);
                UpdateAttributesPacket attributesPacket = new UpdateAttributesPacket();
                attributesPacket.setRuntimeEntityId(entity.geyserId());
                attributesPacket.getAttributes().addAll(entity.getAttributes().values());
                session.sendUpstreamPacket(attributesPacket);
                entity.updateBoundingBox();
                session.getEntityCache().updateBossBars();
                break;
            }
            case STOP_SLEEP: {
                ServerboundPlayerCommandPacket stopSleepingPacket = new ServerboundPlayerCommandPacket(session.getPlayerEntity().getEntityId(), PlayerState.LEAVE_BED);
                session.sendDownstreamGamePacket(stopSleepingPacket);
                break;
            }
            case DIMENSION_CHANGE_REQUEST_OR_CREATIVE_DESTROY_BLOCK: {
                Vector3i vector = packet.getBlockPosition();
                BlockState state = session.getGeyser().getWorldManager().blockAt(session, vector);
                if (state.getValue(Properties.HAS_BOOK, false).booleanValue()) {
                    session.setDroppingLecternBook(true);
                    ServerboundUseItemOnPacket blockPacket = new ServerboundUseItemOnPacket(vector, Direction.DOWN, Hand.MAIN_HAND, 0.0f, 0.0f, 0.0f, false, false, session.getWorldCache().nextPredictionSequence());
                    session.sendDownstreamGamePacket(blockPacket);
                    break;
                }
                ItemFrameEntity itemFrame = ItemFrameEntity.getItemFrameEntity(session, vector);
                if (itemFrame == null) break;
                ServerboundInteractPacket interactPacket = new ServerboundInteractPacket(itemFrame.getEntityId(), InteractAction.ATTACK, Hand.MAIN_HAND, session.isSneaking());
                session.sendDownstreamGamePacket(interactPacket);
                break;
            }
            case DIMENSION_CHANGE_SUCCESS: {
                SessionPlayerEntity entity = session.getPlayerEntity();
                PlayStatusPacket spawnPacket = new PlayStatusPacket();
                spawnPacket.setStatus(PlayStatusPacket.Status.PLAYER_SPAWN);
                session.sendUpstreamPacket(spawnPacket);
                UpdateAttributesPacket attributesPacket = new UpdateAttributesPacket();
                attributesPacket.setRuntimeEntityId(entity.geyserId());
                attributesPacket.getAttributes().addAll(entity.getAttributes().values());
                session.sendUpstreamPacket(attributesPacket);
            }
        }
    }
}

