/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.item;

import com.google.common.collect.SortedSetMultimap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.Collection;
import net.kyori.adventure.key.Key;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.api.predicate.MinecraftPredicate;
import org.geysermc.geyser.api.predicate.PredicateStrategy;
import org.geysermc.geyser.api.predicate.context.item.ItemPredicateContext;
import org.geysermc.geyser.item.GeyserCustomMappingData;
import org.geysermc.geyser.item.custom.GeyserItemPredicateContext;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.definitions.ItemDefinition;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;

public final class CustomItemTranslator {
    public static @Nullable ItemDefinition getCustomItem(GeyserSession session, int stackSize, DataComponents components, ItemMapping mapping) {
        if (components == null) {
            return null;
        }
        SortedSetMultimap<Key, GeyserCustomMappingData> allCustomItems = mapping.getCustomItemDefinitions();
        if (allCustomItems == null) {
            return null;
        }
        Key itemModel = components.get(DataComponentTypes.ITEM_MODEL);
        if (itemModel == null) {
            return null;
        }
        Collection customItems = allCustomItems.get((Object)itemModel);
        if (customItems.isEmpty()) {
            return null;
        }
        ItemPredicateContext context = GeyserItemPredicateContext.create(session, stackSize, components);
        Object2BooleanOpenHashMap calculatedPredicates = new Object2BooleanOpenHashMap();
        for (GeyserCustomMappingData customMapping : customItems) {
            boolean needsOnlyOneMatch = customMapping.definition().predicateStrategy() == PredicateStrategy.OR;
            boolean allMatch = true;
            for (MinecraftPredicate<? super ItemPredicateContext> predicate : customMapping.definition().predicates()) {
                boolean value = calculatedPredicates.computeIfAbsent(predicate, x -> predicate.test(context));
                if (value) {
                    if (!needsOnlyOneMatch) continue;
                    return customMapping.itemDefinition();
                }
                allMatch = false;
                if (needsOnlyOneMatch) continue;
                break;
            }
            if (!allMatch) continue;
            return customMapping.itemDefinition();
        }
        return null;
    }

    private CustomItemTranslator() {
    }
}

