/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.collision.fixes;

import lombok.Generated;
import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.level.physics.BoundingBox;
import org.geysermc.geyser.level.physics.Direction;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.collision.BlockCollision;
import org.geysermc.geyser.translator.collision.CollisionRemapper;

@CollisionRemapper(regex="^end_portal_frame$", passDefaultBoxes=true)
public class EndPortalCollision
extends BlockCollision {
    private static final double MAX_PUSH_DISTANCE = 0.1875101;
    private final boolean eye;

    public EndPortalCollision(BlockState state, BoundingBox[] boxes) {
        super(boxes);
        this.eye = state.getValue(Properties.EYE);
    }

    @Override
    protected void correctPosition(GeyserSession session, int x, int y, int z, BoundingBox blockCollision, BoundingBox playerCollision, double ulpX, double ulpZ) {
        if (!this.eye) {
            return;
        }
        blockCollision.pushOutOfBoundingBox(playerCollision, Direction.UP, 0.1875101);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EndPortalCollision)) {
            return false;
        }
        EndPortalCollision other = (EndPortalCollision)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.eye == other.eye;
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EndPortalCollision;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.eye ? 79 : 97);
        return result;
    }
}

