/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity;

public final class EntityLinkData {
    private final long from;
    private final long to;
    private final Type type;
    private final boolean immediate;
    private final boolean riderInitiated;
    private final float vehicleAngularVelocity;

    @Deprecated
    public EntityLinkData(long from, long to, Type type, boolean immediate) {
        this(from, to, type, immediate, false, 0.0f);
    }

    @Deprecated
    public EntityLinkData(long from, long to, Type type, boolean immediate, boolean riderInitiated) {
        this(from, to, type, immediate, riderInitiated, 0.0f);
    }

    public long getFrom() {
        return this.from;
    }

    public long getTo() {
        return this.to;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isImmediate() {
        return this.immediate;
    }

    public boolean isRiderInitiated() {
        return this.riderInitiated;
    }

    public float getVehicleAngularVelocity() {
        return this.vehicleAngularVelocity;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityLinkData)) {
            return false;
        }
        EntityLinkData other = (EntityLinkData)o;
        if (this.getFrom() != other.getFrom()) {
            return false;
        }
        if (this.getTo() != other.getTo()) {
            return false;
        }
        if (this.isImmediate() != other.isImmediate()) {
            return false;
        }
        if (this.isRiderInitiated() != other.isRiderInitiated()) {
            return false;
        }
        if (Float.compare(this.getVehicleAngularVelocity(), other.getVehicleAngularVelocity()) != 0) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $from = this.getFrom();
        result = result * 59 + (int)($from >>> 32 ^ $from);
        long $to = this.getTo();
        result = result * 59 + (int)($to >>> 32 ^ $to);
        result = result * 59 + (this.isImmediate() ? 79 : 97);
        result = result * 59 + (this.isRiderInitiated() ? 79 : 97);
        result = result * 59 + Float.floatToIntBits(this.getVehicleAngularVelocity());
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    public String toString() {
        return "EntityLinkData(from=" + this.getFrom() + ", to=" + this.getTo() + ", type=" + (Object)((Object)this.getType()) + ", immediate=" + this.isImmediate() + ", riderInitiated=" + this.isRiderInitiated() + ", vehicleAngularVelocity=" + this.getVehicleAngularVelocity() + ")";
    }

    public EntityLinkData(long from, long to, Type type, boolean immediate, boolean riderInitiated, float vehicleAngularVelocity) {
        this.from = from;
        this.to = to;
        this.type = type;
        this.immediate = immediate;
        this.riderInitiated = riderInitiated;
        this.vehicleAngularVelocity = vehicleAngularVelocity;
    }

    public static enum Type {
        REMOVE,
        RIDER,
        PASSENGER;

        private static final Type[] VALUES;

        public static Type byId(int id) {
            if (id >= 0 && id < VALUES.length) {
                return VALUES[id];
            }
            throw new UnsupportedOperationException("Unknown EntityLinkData.Type ID: " + id);
        }

        static {
            VALUES = Type.values();
        }
    }
}

