/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity;

import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.nbt.NbtUtils;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityDataType;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.common.util.Preconditions;

public final class EntityDataMap
implements Map<EntityDataType<?>, Object> {
    private final Map<EntityDataType<?>, Object> map = new LinkedHashMap();

    public static EnumMap<EntityFlag, Boolean> flagsOf(EntityFlag ... flags) {
        EnumMap<EntityFlag, Boolean> map = new EnumMap<EntityFlag, Boolean>(EntityFlag.class);
        for (EntityFlag flag : flags) {
            map.put(flag, true);
        }
        return map;
    }

    public @NonNull EnumMap<EntityFlag, Boolean> getOrCreateFlags() {
        EnumMap<EntityFlag, Boolean> flags = this.get(EntityDataTypes.FLAGS);
        if (flags == null) {
            flags = this.get(EntityDataTypes.FLAGS_2);
            if (flags == null) {
                flags = new EnumMap(EntityFlag.class);
            }
            this.putFlags(flags);
        }
        return flags;
    }

    public EnumMap<EntityFlag, Boolean> getFlags() {
        return this.get(EntityDataTypes.FLAGS);
    }

    public boolean getFlag(EntityFlag flag) {
        EnumMap<EntityFlag, Boolean> flags = this.getFlags();
        return flags != null && Boolean.TRUE.equals(flags.get((Object)flag));
    }

    public boolean isFlagPresent(EntityFlag flag) {
        EnumMap<EntityFlag, Boolean> flags = this.getFlags();
        return flags != null && flags.containsKey((Object)flag);
    }

    public EntityFlag clearFlag(EntityFlag flag) {
        Objects.requireNonNull(flag, "flag");
        EnumMap<EntityFlag, Boolean> flags = this.getOrCreateFlags();
        flags.remove((Object)flag);
        return flag;
    }

    public EntityFlag setFlag(EntityFlag flag, boolean value) {
        Objects.requireNonNull(flag, "flag");
        EnumMap<EntityFlag, Boolean> flags = this.getOrCreateFlags();
        flags.put(flag, value);
        return flag;
    }

    public EnumMap<EntityFlag, Boolean> putFlags(EnumMap<EntityFlag, Boolean> flags) {
        Objects.requireNonNull(flags, "flags");
        this.map.put(EntityDataTypes.FLAGS, flags);
        this.map.put(EntityDataTypes.FLAGS_2, flags);
        return flags;
    }

    public <T> T get(EntityDataType<T> type) {
        return (T)this.map.get(type);
    }

    public <T, U extends T> U get(EntityDataType<T> type, Class<U> clazz) {
        return clazz.cast(this.map.get(type));
    }

    private <T> @NonNull T getOrDefault(EntityDataType<T> type, T defaultValue) {
        Objects.requireNonNull(type, "type");
        Object object = this.map.getOrDefault(type, defaultValue);
        try {
            return (T)object;
        }
        catch (ClassCastException e) {
            return defaultValue;
        }
    }

    public <T> void putType(EntityDataType<T> type, T value) {
        this.put(type, value);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.map.get(key);
    }

    @Override
    public Object put(EntityDataType<?> key, Object value) {
        Preconditions.checkNotNull(key, "type");
        Preconditions.checkNotNull(value, "value was null for %s", key);
        Preconditions.checkArgument(key.isInstance(value), "value with type %s is not an instance of %s", value.getClass(), key);
        if (key == EntityDataTypes.FLAGS || key == EntityDataTypes.FLAGS_2) {
            return this.putFlags((EnumMap)value);
        }
        return this.map.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(@NonNull Map<? extends EntityDataType<?>, ?> map) {
        Preconditions.checkNotNull(map, "map");
        this.map.putAll(map);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public @NonNull Set<EntityDataType<?>> keySet() {
        return this.map.keySet();
    }

    @Override
    public @NonNull Collection<Object> values() {
        return this.map.values();
    }

    @Override
    public @NonNull Set<Map.Entry<EntityDataType<?>, Object>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityDataMap that = (EntityDataMap)o;
        return this.map.equals(that.map);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        Iterator<Map.Entry<EntityDataType<?>, Object>> i = this.map.entrySet().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (i.hasNext()) {
            Map.Entry<EntityDataType<?>, Object> e = i.next();
            EntityDataType<?> key = e.getKey();
            if (key == EntityDataTypes.FLAGS_2) continue;
            String stringVal = NbtUtils.toString((Object)e.getValue());
            sb.append(key.toString()).append('=').append(stringVal);
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
        return sb.toString();
    }
}

