/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.cache;

import lombok.Generated;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.CooldownUtils;

public class PreferencesCache {
    private final GeyserSession session;
    private boolean prefersShowCoordinates = true;
    private boolean allowShowCoordinates;
    private boolean prefersCustomSkulls;
    private CooldownUtils.CooldownType cooldownPreference;

    public PreferencesCache(GeyserSession session) {
        this.session = session;
        this.prefersCustomSkulls = session.getGeyser().config().gameplay().maxVisibleCustomSkulls() != 0;
        this.cooldownPreference = session.getGeyser().config().gameplay().showCooldown();
    }

    public void updateShowCoordinates() {
        this.allowShowCoordinates = !this.session.isReducedDebugInfo() && this.session.getGeyser().config().gameplay().showCoordinates();
        this.session.sendGameRule("showcoordinates", this.allowShowCoordinates && this.prefersShowCoordinates);
    }

    public boolean showCustomSkulls() {
        return this.prefersCustomSkulls && this.session.getGeyser().config().gameplay().maxVisibleCustomSkulls() != 0;
    }

    @Generated
    public GeyserSession getSession() {
        return this.session;
    }

    @Generated
    public boolean isPrefersShowCoordinates() {
        return this.prefersShowCoordinates;
    }

    @Generated
    public boolean isAllowShowCoordinates() {
        return this.allowShowCoordinates;
    }

    @Generated
    public boolean isPrefersCustomSkulls() {
        return this.prefersCustomSkulls;
    }

    @Generated
    public CooldownUtils.CooldownType getCooldownPreference() {
        return this.cooldownPreference;
    }

    @Generated
    public void setPrefersShowCoordinates(boolean prefersShowCoordinates) {
        this.prefersShowCoordinates = prefersShowCoordinates;
    }

    @Generated
    public void setPrefersCustomSkulls(boolean prefersCustomSkulls) {
        this.prefersCustomSkulls = prefersCustomSkulls;
    }

    @Generated
    public void setCooldownPreference(CooldownUtils.CooldownType cooldownPreference) {
        this.cooldownPreference = cooldownPreference;
    }
}

