/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.populator;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.kyori.adventure.key.Key;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.nbt.NbtType;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.item.custom.CustomRenderOffsets;
import org.geysermc.geyser.api.item.custom.v2.CustomItemBedrockOptions;
import org.geysermc.geyser.api.item.custom.v2.CustomItemDefinition;
import org.geysermc.geyser.api.item.custom.v2.CustomItemDefinitionRegisterException;
import org.geysermc.geyser.api.item.custom.v2.NonVanillaCustomItemDefinition;
import org.geysermc.geyser.api.item.custom.v2.component.geyser.GeyserBlockPlacer;
import org.geysermc.geyser.api.item.custom.v2.component.geyser.GeyserChargeable;
import org.geysermc.geyser.api.item.custom.v2.component.geyser.GeyserItemDataComponents;
import org.geysermc.geyser.api.item.custom.v2.component.geyser.GeyserThrowableComponent;
import org.geysermc.geyser.api.item.custom.v2.component.java.JavaItemDataComponents;
import org.geysermc.geyser.api.item.custom.v2.component.java.JavaRepairable;
import org.geysermc.geyser.api.predicate.MinecraftPredicate;
import org.geysermc.geyser.api.predicate.context.item.ItemPredicateContext;
import org.geysermc.geyser.api.predicate.item.ItemConditionPredicate;
import org.geysermc.geyser.api.util.CreativeCategory;
import org.geysermc.geyser.api.util.Identifier;
import org.geysermc.geyser.api.util.Unit;
import org.geysermc.geyser.event.type.GeyserDefineCustomItemsEventImpl;
import org.geysermc.geyser.impl.HoldersImpl;
import org.geysermc.geyser.item.GeyserCustomMappingData;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.custom.GeyserCustomItemDefinition;
import org.geysermc.geyser.item.exception.InvalidItemComponentsException;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.item.type.NonVanillaItem;
import org.geysermc.geyser.network.GameProtocol;
import org.geysermc.geyser.registry.mappings.MappingsConfigReader;
import org.geysermc.geyser.registry.populator.custom.CustomItemContext;
import org.geysermc.geyser.registry.type.GeyserMappingItem;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.registry.type.NonVanillaItemRegistration;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.definitions.SimpleItemDefinition;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.ItemVersion;
import org.geysermc.geyser.util.MinecraftKey;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.AttackRange;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.Consumable;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.Equippable;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.FoodProperties;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.KineticWeapon;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.PiercingWeapon;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.SwingAnimation;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.ToolData;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.UseCooldown;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.UseEffects;

public class CustomItemRegistryPopulator {
    private static final Map<Consumable.ItemUseAnimation, Integer> BEDROCK_ANIMATIONS = Map.of(Consumable.ItemUseAnimation.NONE, 0, Consumable.ItemUseAnimation.EAT, 1, Consumable.ItemUseAnimation.DRINK, 2, Consumable.ItemUseAnimation.BLOCK, 3, Consumable.ItemUseAnimation.BOW, 4, Consumable.ItemUseAnimation.SPEAR, 6, Consumable.ItemUseAnimation.CROSSBOW, 9, Consumable.ItemUseAnimation.SPYGLASS, 10, Consumable.ItemUseAnimation.BRUSH, 12);
    private static final float DEFAULT_ITEM_USE_DURATION = 1000.0f;
    private static final AttackRange DEFAULT_ATTACK_RANGE = new AttackRange(0.0f, 3.0f, 0.0f, 5.0f, 0.3f, 1.0f);
    private static final UseEffects DEFAULT_USE_EFFECTS = new UseEffects(false, true, 0.2f);

    public static void populate(final Map<String, GeyserMappingItem> items, final Multimap<Identifier, CustomItemDefinition> customItems, final Multimap<Identifier, NonVanillaCustomItemDefinition> nonVanillaCustomItems) {
        MappingsConfigReader mappingsConfigReader = new MappingsConfigReader();
        mappingsConfigReader.loadItemMappingsFromJson((identifier, item) -> {
            try {
                CustomItemRegistryPopulator.validateVanillaOverride(identifier, item, customItems, items);
                customItems.get(identifier).add(item);
            }
            catch (CustomItemDefinitionRegisterException exception) {
                GeyserImpl.getInstance().getLogger().error("Not registering custom item definition (bedrock identifier=" + String.valueOf(item.bedrockIdentifier()) + "): " + exception.getMessage());
            }
        });
        GeyserImpl.getInstance().eventBus().fire(new GeyserDefineCustomItemsEventImpl(customItems, nonVanillaCustomItems){

            @Override
            public void register(@NonNull Identifier identifier, @NonNull CustomItemDefinition definition) {
                try {
                    CustomItemRegistryPopulator.validateVanillaOverride(identifier, definition, (Multimap<Identifier, CustomItemDefinition>)customItems, items);
                    customItems.get((Object)identifier).add(definition);
                }
                catch (CustomItemDefinitionRegisterException registerException) {
                    throw new CustomItemDefinitionRegisterException("Not registering custom item definition (bedrock identifier=" + String.valueOf(definition.bedrockIdentifier()) + "): " + registerException.getMessage());
                }
            }

            @Override
            public void register(@NonNull NonVanillaCustomItemDefinition definition) {
                if (definition.identifier().vanilla()) {
                    throw new CustomItemDefinitionRegisterException("Non-vanilla custom item definition (identifier=" + String.valueOf(definition.identifier()) + ") is attempting to masquerade as a vanilla Minecraft item!");
                }
                if (definition.bedrockIdentifier().vanilla()) {
                    throw new CustomItemDefinitionRegisterException("Non-vanilla custom item definition (identifier=" + String.valueOf(definition.identifier()) + ")' bedrock identifier's namespace is minecraft!");
                }
                if (definition.javaId() < items.size()) {
                    throw new CustomItemDefinitionRegisterException("Non-vanilla custom item definition (identifier=" + String.valueOf(definition.identifier()) + ") is attempting to overwrite a vanilla Minecraft item! (item network ID taken)");
                }
                for (NonVanillaCustomItemDefinition existing : nonVanillaCustomItems.values()) {
                    if (!existing.identifier().equals(definition.identifier()) && existing.javaId() != definition.javaId()) continue;
                    throw new CustomItemDefinitionRegisterException("A non-vanilla custom item definition (identifier=" + String.valueOf(definition.identifier()) + ", network ID=" + definition.javaId() + ") is already registered!");
                }
                nonVanillaCustomItems.put((Object)definition.identifier(), (Object)definition);
            }
        });
        int customItemCount = customItems.size() + nonVanillaCustomItems.size();
        if (customItemCount > 0) {
            GeyserImpl.getInstance().getLogger().info("Registered " + customItemCount + " custom items");
        }
    }

    public static GeyserCustomMappingData registerCustomItem(Item javaItem, GeyserMappingItem vanillaMapping, CustomItemDefinition customItem, int bedrockId, int protocolVersion) throws InvalidItemComponentsException {
        CustomItemContext context = CustomItemContext.createVanillaAndValidateComponents(javaItem, vanillaMapping, customItem, bedrockId, protocolVersion);
        NbtMapBuilder bedrockComponents = CustomItemRegistryPopulator.createComponentNbt(javaItem.javaKey(), context);
        SimpleItemDefinition itemDefinition = new SimpleItemDefinition(customItem.bedrockIdentifier().toString(), bedrockId, ItemVersion.DATA_DRIVEN, true, bedrockComponents.build());
        return new GeyserCustomMappingData(customItem, itemDefinition, bedrockId);
    }

    public static NonVanillaItemRegistration registerCustomItem(NonVanillaCustomItemDefinition customItem, int bedrockId, int protocolVersion) throws InvalidItemComponentsException {
        CustomItemContext context = CustomItemContext.createNonVanillaAndValidateComponents(customItem, bedrockId, protocolVersion);
        String bedrockIdentifier = customItem.bedrockIdentifier().toString();
        NbtMapBuilder bedrockComponents = CustomItemRegistryPopulator.createComponentNbt(MinecraftKey.identifierToKey(customItem.identifier()), context);
        NonVanillaItem javaItem = new NonVanillaItem(customItem.identifier().toString(), Item.builder().components(context.components()), context.resolvableComponents());
        Items.register(javaItem, customItem.javaId());
        ItemMapping customMapping = ItemMapping.builder().bedrockIdentifier(bedrockIdentifier).bedrockDefinition(new SimpleItemDefinition(bedrockIdentifier, bedrockId, ItemVersion.DATA_DRIVEN, true, bedrockComponents.build())).bedrockData(0).bedrockBlockDefinition(null).translationString(customItem.translationString()).javaItem(javaItem).build();
        return new NonVanillaItemRegistration(javaItem, customMapping);
    }

    private static void validateVanillaOverride(Identifier vanillaIdentifier, CustomItemDefinition item, Multimap<Identifier, CustomItemDefinition> registered, Map<String, GeyserMappingItem> mappings) throws CustomItemDefinitionRegisterException {
        if (!mappings.containsKey(vanillaIdentifier.toString())) {
            throw new CustomItemDefinitionRegisterException("unknown Java item " + String.valueOf(vanillaIdentifier));
        }
        Identifier bedrockIdentifier = item.bedrockIdentifier();
        if (bedrockIdentifier.vanilla()) {
            throw new CustomItemDefinitionRegisterException("custom item bedrock identifier namespace can't be minecraft");
        }
        if (item.model().equals(vanillaIdentifier) && item.predicates().isEmpty()) {
            throw new CustomItemDefinitionRegisterException("custom item definition model can't equal vanilla item identifier without a predicate");
        }
        for (Map.Entry entry : registered.entries()) {
            if (((CustomItemDefinition)entry.getValue()).bedrockIdentifier().equals(item.bedrockIdentifier())) {
                throw new CustomItemDefinitionRegisterException("conflicts with another custom item definition with the same bedrock identifier");
            }
            try {
                CustomItemRegistryPopulator.checkPredicate(entry, vanillaIdentifier, item);
            }
            catch (CustomItemDefinitionRegisterException exception) {
                throw new CustomItemDefinitionRegisterException("conflicts with custom item definition (bedrock identifier=" + String.valueOf(((CustomItemDefinition)entry.getValue()).bedrockIdentifier()) + "): " + exception.getMessage());
            }
        }
    }

    private static void checkPredicate(Map.Entry<Identifier, CustomItemDefinition> existing, Identifier vanillaIdentifier, CustomItemDefinition newItem) throws CustomItemDefinitionRegisterException {
        if (!vanillaIdentifier.equals(existing.getKey()) || !newItem.model().equals(existing.getValue().model())) {
            return;
        }
        if (existing.getValue().predicates().isEmpty() && newItem.predicates().isEmpty()) {
            throw new CustomItemDefinitionRegisterException("both entries don't have predicates, one must have a predicate");
        }
        if (existing.getValue().predicates().size() == newItem.predicates().size()) {
            boolean equal = true;
            for (MinecraftPredicate<? super ItemPredicateContext> predicate : existing.getValue().predicates()) {
                if (newItem.predicates().contains(predicate)) continue;
                equal = false;
                break;
            }
            if (equal) {
                throw new CustomItemDefinitionRegisterException("both entries have the same predicates");
            }
        }
    }

    private static NbtMapBuilder createComponentNbt(Key itemIdentifier, CustomItemContext context) {
        GeyserCustomItemDefinition definition;
        CustomItemDefinition customItemDefinition;
        Unit entityPlacer;
        GeyserThrowableComponent throwable;
        GeyserChargeable chargeable;
        GeyserBlockPlacer blockPlacer;
        Boolean glint;
        Integer enchantmentValue;
        Equippable equippable;
        ToolData toolData;
        NbtMapBuilder builder = NbtMap.builder().putString("name", context.definition().bedrockIdentifier().toString()).putInt("id", context.customItemId());
        NbtMapBuilder itemProperties = NbtMap.builder();
        NbtMapBuilder componentBuilder = NbtMap.builder();
        CustomItemRegistryPopulator.setupBasicItemInfo(context.definition(), context.components(), itemProperties, componentBuilder);
        CustomItemRegistryPopulator.computeToolProperties(itemProperties, componentBuilder);
        Integer attackDamage = context.definition().components().get(GeyserItemDataComponents.ATTACK_DAMAGE);
        if (attackDamage != null) {
            itemProperties.putInt("damage", attackDamage.intValue());
            componentBuilder.putCompound("minecraft:damage", NbtMap.builder().putByte("value", attackDamage.byteValue()).build());
        }
        boolean canDestroyInCreative = (toolData = context.components().get(DataComponentTypes.TOOL)) == null || toolData.isCanDestroyBlocksInCreative();
        CustomItemRegistryPopulator.computeCreativeDestroyProperties(canDestroyInCreative, itemProperties, componentBuilder);
        JavaRepairable repairable = context.definition().components().get(JavaItemDataComponents.REPAIRABLE);
        if (repairable != null) {
            CustomItemRegistryPopulator.computeRepairableProperties(repairable, componentBuilder);
        }
        if ((equippable = context.components().get(DataComponentTypes.EQUIPPABLE)) != null) {
            GeyserCustomItemDefinition definition2;
            CustomItemDefinition customItemDefinition2 = context.definition();
            boolean renderOffsets = customItemDefinition2 instanceof GeyserCustomItemDefinition && (definition2 = (GeyserCustomItemDefinition)customItemDefinition2).isOldConvertedItem();
            CustomItemRegistryPopulator.computeArmorProperties(equippable, context.definition().bedrockOptions().protectionValue(), componentBuilder, renderOffsets);
        }
        if ((enchantmentValue = context.components().get(DataComponentTypes.ENCHANTABLE)) != null && enchantmentValue > 0) {
            CustomItemRegistryPopulator.computeEnchantableProperties(enchantmentValue, itemProperties, componentBuilder);
        }
        if ((glint = context.components().get(DataComponentTypes.ENCHANTMENT_GLINT_OVERRIDE)) != null) {
            itemProperties.putBoolean("foil", glint.booleanValue());
            componentBuilder.putCompound("minecraft:glint", NbtMap.builder().putBoolean("value", glint.booleanValue()).build());
        }
        if (GameProtocol.is1_21_130orHigher(context.protocolVersion())) {
            SwingAnimation swingAnimation;
            PiercingWeapon piercingWeapon;
            AttackRange attackRange = context.components().getOrDefault(DataComponentTypes.ATTACK_RANGE, DEFAULT_ATTACK_RANGE);
            KineticWeapon kineticWeapon = context.components().get(DataComponentTypes.KINETIC_WEAPON);
            if (kineticWeapon != null) {
                CustomItemRegistryPopulator.computeKineticWeaponProperties(componentBuilder, kineticWeapon, attackRange);
            }
            if ((piercingWeapon = context.components().get(DataComponentTypes.PIERCING_WEAPON)) != null) {
                CustomItemRegistryPopulator.computePiercingWeaponProperties(componentBuilder, attackRange);
            }
            if ((swingAnimation = context.components().get(DataComponentTypes.SWING_ANIMATION)) != null) {
                CustomItemRegistryPopulator.computeSwingAnimationProperties(componentBuilder, swingAnimation);
            }
        }
        Optional<Consumable> consumableComponent = Optional.ofNullable(context.components().get(DataComponentTypes.CONSUMABLE)).or(() -> context.vanillaMapping().flatMap(mapping -> {
            if (mapping.getBedrockIdentifier().equals("minecraft:trident")) {
                return Optional.of(new Consumable(1000.0f, Consumable.ItemUseAnimation.TRIDENT, null, false, List.of()));
            }
            return Optional.empty();
        }));
        consumableComponent.ifPresent(consumable -> {
            FoodProperties foodProperties = context.components().get(DataComponentTypes.FOOD);
            CustomItemRegistryPopulator.computeConsumableProperties(consumable, foodProperties, itemProperties, componentBuilder);
        });
        UseCooldown useCooldown = context.components().get(DataComponentTypes.USE_COOLDOWN);
        if (useCooldown != null) {
            CustomItemRegistryPopulator.computeUseCooldownProperties(useCooldown, itemIdentifier, componentBuilder);
        }
        if ((blockPlacer = context.vanillaMapping().map(mapping -> {
            String bedrockIdentifier = mapping.getBedrockIdentifier();
            if (bedrockIdentifier.equals("minecraft:fire_charge") || bedrockIdentifier.equals("minecraft:flint_and_steel")) {
                return GeyserBlockPlacer.builder().block(Identifier.of("fire")).build();
            }
            if (mapping.getFirstBlockRuntimeId() != null) {
                return GeyserBlockPlacer.builder().block(Identifier.of(mapping.getBedrockIdentifier())).build();
            }
            return null;
        }).orElse(context.definition().components().get(GeyserItemDataComponents.BLOCK_PLACER))) != null) {
            CustomItemRegistryPopulator.computeBlockItemProperties(blockPlacer, componentBuilder);
        }
        if ((chargeable = context.vanillaMapping().map(GeyserMappingItem::getBedrockIdentifier).map(identifier -> switch (identifier) {
            case "minecraft:bow" -> GeyserChargeable.builder().maxDrawDuration(1.0f).ammunition(Identifier.of("arrow")).build();
            case "minecraft:crossbow" -> GeyserChargeable.builder().chargeOnDraw(true).ammunition(Identifier.of("arrow")).build();
            default -> null;
        }).orElse(context.definition().components().get(GeyserItemDataComponents.CHARGEABLE))) != null) {
            CustomItemRegistryPopulator.computeChargeableProperties(itemProperties, componentBuilder, chargeable);
        }
        if ((throwable = context.vanillaMapping().map(GeyserMappingItem::getBedrockIdentifier).map(identifier -> switch (identifier) {
            case "minecraft:experience_bottle", "minecraft:egg", "minecraft:ender_pearl", "minecraft:ender_eye", "minecraft:lingering_potion", "minecraft:snowball", "minecraft:splash_potion" -> GeyserThrowableComponent.of(true);
            default -> null;
        }).orElse(context.definition().components().get(GeyserItemDataComponents.THROWABLE))) != null) {
            CustomItemRegistryPopulator.computeThrowableProperties(componentBuilder, throwable);
        } else if (context.definition().components().get(GeyserItemDataComponents.PROJECTILE) != null) {
            CustomItemRegistryPopulator.computeProjectileProperties(componentBuilder);
        }
        if (throwable != null || chargeable != null || consumableComponent.isPresent()) {
            CustomItemRegistryPopulator.computeUseEffectsProperties(itemProperties, componentBuilder, context.components().getOrDefault(DataComponentTypes.USE_EFFECTS, DEFAULT_USE_EFFECTS), consumableComponent.map(Consumable::consumeSeconds));
        }
        if ((entityPlacer = context.vanillaMapping().map(mapping -> {
            if (mapping.isEntityPlacer()) {
                return Unit.INSTANCE;
            }
            return null;
        }).orElse(context.definition().components().get(GeyserItemDataComponents.ENTITY_PLACER))) != null) {
            CustomItemRegistryPopulator.computeEntityPlacerProperties(componentBuilder);
        }
        if ((customItemDefinition = context.definition()) instanceof GeyserCustomItemDefinition && (definition = (GeyserCustomItemDefinition)customItemDefinition).isOldConvertedItem()) {
            CustomRenderOffsets renderOffsets = definition.getRenderOffsets();
            if (renderOffsets != null) {
                componentBuilder.remove((Object)"minecraft:render_offsets");
                componentBuilder.putCompound("minecraft:render_offsets", CustomItemRegistryPopulator.toNbtMap(renderOffsets));
            } else if (definition.getTextureSize() != 16 && !componentBuilder.containsKey((Object)"minecraft:render_offsets")) {
                float scale1 = (float)(0.075 / (double)((float)definition.getTextureSize() / 16.0f));
                float scale2 = (float)(0.125 / (double)((float)definition.getTextureSize() / 16.0f));
                float scale3 = (float)(0.075 / (double)((float)definition.getTextureSize() / 16.0f * 2.4f));
                componentBuilder.putCompound("minecraft:render_offsets", NbtMap.builder().putCompound("main_hand", NbtMap.builder().putCompound("first_person", CustomItemRegistryPopulator.xyzToScaleList(scale3, scale3, scale3)).putCompound("third_person", CustomItemRegistryPopulator.xyzToScaleList(scale1, scale2, scale1)).build()).putCompound("off_hand", NbtMap.builder().putCompound("first_person", CustomItemRegistryPopulator.xyzToScaleList(scale1, scale2, scale1)).putCompound("third_person", CustomItemRegistryPopulator.xyzToScaleList(scale1, scale2, scale1)).build()).build());
            }
        }
        componentBuilder.putCompound("item_properties", itemProperties.build());
        builder.putCompound("components", componentBuilder.build());
        return builder;
    }

    private static void setupBasicItemInfo(CustomItemDefinition definition, DataComponents components, NbtMapBuilder itemProperties, NbtMapBuilder componentBuilder) {
        CustomItemBedrockOptions options = definition.bedrockOptions();
        GeyserBlockPlacer blockPlacer = definition.components().get(GeyserItemDataComponents.BLOCK_PLACER);
        if (blockPlacer == null || !blockPlacer.useBlockIcon()) {
            NbtMap iconMap = NbtMap.builder().putCompound("textures", NbtMap.builder().putString("default", definition.icon()).build()).build();
            itemProperties.putCompound("minecraft:icon", iconMap);
        }
        if (options.creativeCategory() != CreativeCategory.NONE) {
            itemProperties.putInt("creative_category", options.creativeCategory().id());
            if (options.creativeGroup() != null) {
                itemProperties.putString("creative_group", options.creativeGroup());
            }
        }
        componentBuilder.putCompound("minecraft:display_name", NbtMap.builder().putString("value", definition.displayName()).build());
        CustomItemRegistryPopulator.addItemTag(componentBuilder, Identifier.of("geyser:is_custom"));
        Set<Identifier> tags = options.tags();
        for (Identifier tag : tags) {
            CustomItemRegistryPopulator.addItemTag(componentBuilder, tag);
        }
        itemProperties.putBoolean("allow_off_hand", options.allowOffhand());
        itemProperties.putBoolean("hand_equipped", options.displayHandheld());
        int maxDamage = components.getOrDefault(DataComponentTypes.MAX_DAMAGE, 0);
        int stackSize = components.getOrDefault(DataComponentTypes.MAX_STACK_SIZE, 1);
        itemProperties.putInt("max_stack_size", stackSize);
        if (maxDamage > 0 && !CustomItemRegistryPopulator.isUnbreakableItem(definition)) {
            componentBuilder.putCompound("minecraft:durability", NbtMap.builder().putCompound("damage_chance", NbtMap.builder().putInt("max", 1).putInt("min", 1).build()).putInt("max_durability", maxDamage).build());
        }
    }

    private static void computeToolProperties(NbtMapBuilder itemProperties, NbtMapBuilder componentBuilder) {
        List<NbtMap> speed = List.of(NbtMap.builder().putCompound("block", NbtMap.builder().putString("name", "").putCompound("states", NbtMap.EMPTY).putString("tags", "1").build()).putInt("speed", 1).build());
        componentBuilder.putCompound("minecraft:digger", NbtMap.builder().putList("destroy_speeds", NbtType.COMPOUND, speed).putBoolean("use_efficiency", false).build());
        itemProperties.putFloat("mining_speed", 1.0f);
    }

    private static void computeCreativeDestroyProperties(boolean canDestroyInCreative, NbtMapBuilder itemProperties, NbtMapBuilder componentBuilder) {
        itemProperties.putBoolean("can_destroy_in_creative", canDestroyInCreative);
        componentBuilder.putCompound("minecraft:can_destroy_in_creative", NbtMap.builder().putBoolean("value", canDestroyInCreative).build());
    }

    private static void computeRepairableProperties(JavaRepairable repairable, NbtMapBuilder componentBuilder) {
        List<Identifier> identifiers = ((HoldersImpl)repairable.items()).identifiers();
        if (identifiers == null) {
            return;
        }
        List<NbtMap> items = identifiers.stream().map(identifier -> NbtMap.builder().putString("name", identifier.toString()).build()).toList();
        componentBuilder.putCompound("minecraft:repairable", NbtMap.builder().putList("repair_items", NbtType.COMPOUND, (Object[])new NbtMap[]{NbtMap.builder().putList("items", NbtType.COMPOUND, items).putFloat("repair_amount", 0.0f).build()}).build());
    }

    private static void computeArmorProperties(Equippable equippable, int protectionValue, NbtMapBuilder componentBuilder, boolean includeRenderOffsets) {
        String slotName;
        switch (equippable.slot()) {
            case BOOTS: {
                String string = "armor.feet";
                break;
            }
            case LEGGINGS: {
                String string = "armor.legs";
                break;
            }
            case CHESTPLATE: {
                String string = "armor.chest";
                break;
            }
            case HELMET: {
                String string = "armor.head";
                break;
            }
            case BODY: {
                String string = "armor";
                break;
            }
            case SADDLE: {
                String string = "saddle";
                break;
            }
            default: {
                String string = slotName = "";
            }
        }
        if (slotName.isEmpty()) {
            return;
        }
        if (includeRenderOffsets) {
            String renderOffsetType;
            switch (equippable.slot()) {
                case BOOTS: {
                    String string = "boots";
                    break;
                }
                case LEGGINGS: {
                    String string = "leggings";
                    break;
                }
                case CHESTPLATE: {
                    String string = "chestplates";
                    break;
                }
                case HELMET: {
                    String string = "helmets";
                    break;
                }
                default: {
                    String string = renderOffsetType = null;
                }
            }
            if (renderOffsetType != null) {
                componentBuilder.putString("render_offsets", renderOffsetType);
            }
        }
        componentBuilder.putCompound("minecraft:wearable", NbtMap.builder().putString("slot", "slot." + slotName).putInt("protection", protectionValue).build());
    }

    private static void computeEnchantableProperties(int enchantmentValue, NbtMapBuilder itemProperties, NbtMapBuilder componentBuilder) {
        itemProperties.putString("enchantable_slot", "all");
        itemProperties.putInt("enchantable_value", enchantmentValue);
        componentBuilder.putCompound("minecraft:enchantable", NbtMap.builder().putString("slot", "all").putByte("value", (byte)enchantmentValue).build());
    }

    private static void computeBlockItemProperties(GeyserBlockPlacer blockPlacer, NbtMapBuilder componentBuilder) {
        componentBuilder.putCompound("minecraft:block_placer", NbtMap.builder().putString("block", blockPlacer.block().toString()).putBoolean("canUseBlockAsIcon", blockPlacer.useBlockIcon()).putList("use_on", NbtType.STRING, (Object[])new String[0]).build());
    }

    private static void computeChargeableProperties(NbtMapBuilder itemProperties, NbtMapBuilder componentBuilder, GeyserChargeable chargeable) {
        if (chargeable.chargeOnDraw()) {
            itemProperties.putInt("frame_count", 10);
        } else {
            itemProperties.putInt("frame_count", 3);
        }
        componentBuilder.putCompound("minecraft:shooter", NbtMap.builder().putList("ammunition", NbtType.COMPOUND, chargeable.ammunition().stream().map(ammunition -> NbtMap.builder().putCompound("item", NbtMap.builder().putString("name", ammunition.toString()).build()).putBoolean("use_offhand", true).putBoolean("use_in_creative", false).putBoolean("search_inventory", true).build()).toList()).putBoolean("charge_on_draw", chargeable.chargeOnDraw()).putFloat("max_draw_duration", chargeable.maxDrawDuration()).putBoolean("scale_power_by_draw_duration", true).build());
    }

    private static void computeConsumableProperties(Consumable consumable, @Nullable FoodProperties foodProperties, NbtMapBuilder itemProperties, NbtMapBuilder componentBuilder) {
        String animationName = switch (consumable.animation()) {
            case Consumable.ItemUseAnimation.TRIDENT -> "spear";
            default -> consumable.animation().toString().toLowerCase();
        };
        Integer animationId = BEDROCK_ANIMATIONS.get((Object)consumable.animation());
        if (animationId != null) {
            itemProperties.putInt("use_animation", animationId.intValue());
            componentBuilder.putCompound("minecraft:use_animation", NbtMap.builder().putString("value", animationName).build());
        }
        int nutrition = foodProperties == null ? 0 : foodProperties.getNutrition();
        float saturationModifier = foodProperties == null ? 0.0f : foodProperties.getSaturationModifier();
        boolean canAlwaysEat = foodProperties == null || foodProperties.isCanAlwaysEat();
        componentBuilder.putCompound("minecraft:food", NbtMap.builder().putBoolean("can_always_eat", canAlwaysEat).putInt("nutrition", nutrition).putFloat("saturation_modifier", saturationModifier).putCompound("using_converts_to", NbtMap.EMPTY).build());
    }

    private static void computeEntityPlacerProperties(NbtMapBuilder componentBuilder) {
        componentBuilder.putCompound("minecraft:entity_placer", NbtMap.builder().putList("dispense_on", NbtType.STRING, (Object[])new String[0]).putString("entity", "minecraft:minecart").putList("use_on", NbtType.STRING, (Object[])new String[0]).build());
    }

    private static void computeThrowableProperties(NbtMapBuilder componentBuilder, GeyserThrowableComponent throwable) {
        componentBuilder.putCompound("minecraft:throwable", NbtMap.builder().putBoolean("do_swing_animation", throwable.doSwingAnimation()).build());
        CustomItemRegistryPopulator.computeProjectileProperties(componentBuilder);
    }

    private static void computeProjectileProperties(NbtMapBuilder componentBuilder) {
        componentBuilder.putCompound("minecraft:projectile", NbtMap.builder().putString("projectile_entity", "minecraft:snowball").build());
    }

    private static void computeUseCooldownProperties(UseCooldown cooldown, Key itemIdentifier, NbtMapBuilder componentBuilder) {
        Key group = cooldown.cooldownGroup() == null ? itemIdentifier : cooldown.cooldownGroup();
        componentBuilder.putCompound("minecraft:cooldown", NbtMap.builder().putString("category", group.asString()).putFloat("duration", cooldown.seconds()).build());
    }

    private static void computeKineticWeaponProperties(NbtMapBuilder componentBuilder, KineticWeapon weapon, AttackRange attackRange) {
        NbtMapBuilder component = NbtMap.builder().putShort("delay", (short)weapon.delayTicks()).putFloat("damage_modifier", 0.0f).putFloat("damage_multiplier", 1.0f);
        CustomItemRegistryPopulator.addAttackRangeProperties(component, attackRange);
        CustomItemRegistryPopulator.addKineticConditionMap(component, "dismount_conditions", weapon.dismountConditions());
        componentBuilder.putCompound("minecraft:kinetic_weapon", component.build());
    }

    private static void computePiercingWeaponProperties(NbtMapBuilder componentBuilder, AttackRange attackRange) {
        componentBuilder.putCompound("minecraft:piercing_weapon", CustomItemRegistryPopulator.addAttackRangeProperties(NbtMap.builder(), attackRange).build());
    }

    private static void computeSwingAnimationProperties(NbtMapBuilder componentBuilder, SwingAnimation swingAnimation) {
        componentBuilder.putCompound("minecraft:swing_duration", NbtMap.builder().putFloat("value", (float)swingAnimation.duration() / 20.0f).build());
    }

    private static void computeUseEffectsProperties(NbtMapBuilder itemProperties, NbtMapBuilder componentBuilder, UseEffects effects, Optional<Float> setUseDuration) {
        float useDuration = setUseDuration.orElse(Float.valueOf(1000.0f)).floatValue();
        itemProperties.putInt("use_duration", (int)(useDuration * 20.0f));
        componentBuilder.putCompound("minecraft:use_modifiers", NbtMap.builder().putFloat("movement_modifier", effects.speedMultiplier()).putFloat("use_duration", useDuration).build());
    }

    private static NbtMapBuilder addAttackRangeProperties(NbtMapBuilder component, AttackRange attackRange) {
        return component.putCompound("reach", CustomItemRegistryPopulator.createReachMap(attackRange.minRange(), attackRange.maxRange())).putCompound("creative_reach", CustomItemRegistryPopulator.createReachMap(attackRange.minCreativeRange(), attackRange.maxCreativeRange())).putFloat("hitbox_margin", attackRange.hitboxMargin());
    }

    private static void addKineticConditionMap(NbtMapBuilder component, String key, @Nullable KineticWeapon.Condition condition) {
        if (condition == null) {
            return;
        }
        component.putCompound(key, NbtMap.builder().putShort("max_duration", (short)condition.maxDurationTicks()).putFloat("min_speed", condition.minSpeed()).putFloat("min_relative_speed", condition.minRelativeSpeed()).build());
    }

    private static NbtMap createReachMap(float min, float max) {
        return NbtMap.builder().putFloat("min", min).putFloat("max", max).build();
    }

    private static boolean isUnbreakableItem(CustomItemDefinition definition) {
        for (MinecraftPredicate<? super ItemPredicateContext> predicate : definition.predicates()) {
            if (!predicate.equals(ItemConditionPredicate.UNBREAKABLE)) continue;
            return true;
        }
        return false;
    }

    private static void addItemTag(NbtMapBuilder builder, Identifier tag) {
        ArrayList<String> tagList = (ArrayList<String>)builder.get((Object)"item_tags");
        if (tagList == null) {
            builder.putList("item_tags", NbtType.STRING, (Object[])new String[]{tag.toString()});
        } else if (!tagList.contains(tag.toString())) {
            tagList = new ArrayList<String>(tagList);
            tagList.add(tag.toString());
            builder.putList("item_tags", NbtType.STRING, tagList);
        }
    }

    private static NbtMap toNbtMap(CustomRenderOffsets renderOffsets) {
        NbtMap nbt;
        CustomRenderOffsets.Hand offhand;
        NbtMap nbt2;
        NbtMapBuilder builder = NbtMap.builder();
        CustomRenderOffsets.Hand mainHand = renderOffsets.mainHand();
        if (mainHand != null && (nbt2 = CustomItemRegistryPopulator.toNbtMap(mainHand)) != null) {
            builder.putCompound("main_hand", nbt2);
        }
        if ((offhand = renderOffsets.offhand()) != null && (nbt = CustomItemRegistryPopulator.toNbtMap(offhand)) != null) {
            builder.putCompound("off_hand", nbt);
        }
        return builder.build();
    }

    private static @Nullable NbtMap toNbtMap(CustomRenderOffsets.Hand hand) {
        NbtMap firstPerson = CustomItemRegistryPopulator.toNbtMap(hand.firstPerson());
        NbtMap thirdPerson = CustomItemRegistryPopulator.toNbtMap(hand.thirdPerson());
        if (firstPerson == null && thirdPerson == null) {
            return null;
        }
        NbtMapBuilder builder = NbtMap.builder();
        if (firstPerson != null) {
            builder.putCompound("first_person", firstPerson);
        }
        if (thirdPerson != null) {
            builder.putCompound("third_person", thirdPerson);
        }
        return builder.build();
    }

    private static @Nullable NbtMap toNbtMap(@Nullable CustomRenderOffsets.Offset offset) {
        if (offset == null) {
            return null;
        }
        CustomRenderOffsets.OffsetXYZ position = offset.position();
        CustomRenderOffsets.OffsetXYZ rotation = offset.rotation();
        CustomRenderOffsets.OffsetXYZ scale = offset.scale();
        if (position == null && rotation == null && scale == null) {
            return null;
        }
        NbtMapBuilder builder = NbtMap.builder();
        if (position != null) {
            builder.putList("position", NbtType.FLOAT, CustomItemRegistryPopulator.toList(position));
        }
        if (rotation != null) {
            builder.putList("rotation", NbtType.FLOAT, CustomItemRegistryPopulator.toList(rotation));
        }
        if (scale != null) {
            builder.putList("scale", NbtType.FLOAT, CustomItemRegistryPopulator.toList(scale));
        }
        return builder.build();
    }

    private static List<Float> toList(CustomRenderOffsets.OffsetXYZ xyz) {
        return List.of(Float.valueOf(xyz.x()), Float.valueOf(xyz.y()), Float.valueOf(xyz.z()));
    }

    private static NbtMap xyzToScaleList(float x, float y, float z) {
        return NbtMap.builder().putList("scale", NbtType.FLOAT, List.of(Float.valueOf(x), Float.valueOf(y), Float.valueOf(z))).build();
    }
}

