/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.mappings.predicate;

import com.google.gson.JsonElement;
import org.geysermc.geyser.api.predicate.MinecraftPredicate;
import org.geysermc.geyser.api.predicate.context.item.ItemPredicateContext;
import org.geysermc.geyser.api.predicate.item.ItemRangeDispatchPredicate;
import org.geysermc.geyser.item.exception.InvalidCustomMappingsFileException;
import org.geysermc.geyser.registry.mappings.predicate.PredicateCreator;
import org.geysermc.geyser.registry.mappings.predicate.PredicateReader;
import org.geysermc.geyser.registry.mappings.util.MappingsUtil;
import org.geysermc.geyser.registry.mappings.util.NodeReader;

public enum ItemRangeDispatchProperty implements PredicateReader<ItemPredicateContext>
{
    BUNDLE_FULLNESS(ItemRangeDispatchPredicate::bundleFullness),
    DAMAGE(ItemRangeDispatchPredicate::damage, ItemRangeDispatchPredicate::normalizedDamage),
    COUNT(ItemRangeDispatchPredicate::count, ItemRangeDispatchPredicate::normalizedCount),
    CUSTOM_MODEL_DATA((element, context) -> {
        int index = MappingsUtil.readOrDefault(element, "index", NodeReader.NON_NEGATIVE_INT, 0, context);
        return ItemRangeDispatchPredicate.customModelData(index, (float)ItemRangeDispatchProperty.readThreshold(element, context));
    });

    private final PredicateReader<? super ItemPredicateContext> reader;

    private ItemRangeDispatchProperty(PredicateReader<? super ItemPredicateContext> reader) {
        this.reader = reader;
    }

    private ItemRangeDispatchProperty(PredicateCreator<ItemPredicateContext, Integer> creator) {
        this((JsonElement element, String[] context) -> creator.create((int)ItemRangeDispatchProperty.readThreshold(element, context)));
    }

    private ItemRangeDispatchProperty(PredicateCreator<ItemPredicateContext, Integer> creator, PredicateCreator<ItemPredicateContext, Double> normalized) {
        this((JsonElement element, String[] context) -> {
            double threshold = ItemRangeDispatchProperty.readThreshold(element, context);
            return ItemRangeDispatchProperty.normalized(element, context) ? normalized.create(threshold) : creator.create((int)threshold);
        });
    }

    private static double readThreshold(JsonElement element, String ... context) throws InvalidCustomMappingsFileException {
        double threshold = MappingsUtil.readOrThrow(element, "threshold", NodeReader.DOUBLE, context);
        double scale = MappingsUtil.readOrDefault(element, "scale", NodeReader.DOUBLE, 1.0, context);
        return threshold / scale;
    }

    private static boolean normalized(JsonElement element, String ... context) throws InvalidCustomMappingsFileException {
        return MappingsUtil.readOrDefault(element, "normalize", NodeReader.BOOLEAN, false, context);
    }

    @Override
    public MinecraftPredicate<? super ItemPredicateContext> read(JsonElement element, String ... context) throws InvalidCustomMappingsFileException {
        return this.reader.read(element, context);
    }
}

