/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.mappings.components.readers;

import com.google.gson.JsonElement;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.api.item.custom.v2.component.java.JavaItemDataComponents;
import org.geysermc.geyser.api.item.custom.v2.component.java.JavaRepairable;
import org.geysermc.geyser.api.util.Holders;
import org.geysermc.geyser.api.util.Identifier;
import org.geysermc.geyser.item.custom.impl.JavaRepairableImpl;
import org.geysermc.geyser.item.exception.InvalidCustomMappingsFileException;
import org.geysermc.geyser.registry.mappings.components.DataComponentReader;
import org.geysermc.geyser.registry.mappings.util.MappingsUtil;
import org.geysermc.geyser.registry.mappings.util.NodeReader;

public class RepairableReader
extends DataComponentReader<JavaRepairable> {
    public RepairableReader() {
        super(JavaItemDataComponents.REPAIRABLE);
    }

    @Override
    protected JavaRepairable readDataComponent(@NonNull JsonElement node, String ... context) throws InvalidCustomMappingsFileException {
        try {
            Identifier item = MappingsUtil.readOrThrow(node, "items", NodeReader.IDENTIFIER, context);
            return new JavaRepairableImpl(Holders.of(item));
        }
        catch (InvalidCustomMappingsFileException exception) {
            try {
                List<Identifier> items = MappingsUtil.readArrayOrThrow(node, "items", NodeReader.IDENTIFIER, context);
                return new JavaRepairableImpl(Holders.of(items));
            }
            catch (InvalidCustomMappingsFileException anotherException) {
                Identifier tag = MappingsUtil.readOrThrow(node, "items", NodeReader.TAG, context);
                return new JavaRepairableImpl(Holders.ofTag(tag));
            }
        }
    }
}

