/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.mod.world;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_155;
import net.minecraft.class_1923;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import net.minecraft.class_8172;
import net.minecraft.server.MinecraftServer;
import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.geyser.level.GeyserWorldManager;
import org.geysermc.geyser.network.GameProtocol;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.GameMode;

public class GeyserModWorldManager
extends GeyserWorldManager {
    private final MinecraftServer server;

    public GeyserModWorldManager(MinecraftServer server) {
        this.server = server;
    }

    @Override
    public int getBlockAt(GeyserSession session, int x, int y, int z) {
        class_2826 section;
        if (class_155.method_16673().comp_4027() != GameProtocol.getJavaProtocolVersion()) {
            return super.getBlockAt(session, x, y, z);
        }
        class_3222 player = this.getPlayer(session);
        if (player == null) {
            return 0;
        }
        class_3218 level = player.method_51469();
        if (y < level.method_31607()) {
            return 0;
        }
        class_2818 chunk = ((class_3215)level.method_8398()).field_17254.method_53688(class_1923.method_8331((int)(x >> 4), (int)(z >> 4)));
        if (chunk == null) {
            return 0;
        }
        int worldOffset = level.method_31607() >> 4;
        int chunkOffset = (y >> 4) - worldOffset;
        if (chunkOffset < chunk.method_12006().length && (section = chunk.method_12006()[chunkOffset]) != null && !section.method_38292()) {
            return class_2248.method_9507((class_2680)section.method_12254(x & 0xF, y & 0xF, z & 0xF));
        }
        return 0;
    }

    @Override
    public boolean hasOwnChunkCache() {
        return class_155.method_16673().comp_4027() == GameProtocol.getJavaProtocolVersion();
    }

    @Override
    public GameMode getDefaultGameMode(GeyserSession session) {
        return GameMode.byId(this.server.method_3790().method_8379());
    }

    @Override
    public void getDecoratedPotData(GeyserSession session, Vector3i pos, Consumer<List<String>> apply) {
        this.server.execute(() -> {
            class_3222 player = this.getPlayer(session);
            if (player == null) {
                return;
            }
            class_2338 blockPos = new class_2338(pos.getX(), pos.getY(), pos.getZ());
            class_2586 blockEntity = player.method_51469().method_8500(blockPos).method_8321(blockPos);
            if (blockEntity instanceof class_8172) {
                class_8172 pot = (class_8172)blockEntity;
                List<String> sherds = pot.method_51511().method_51512().stream().map(item -> class_7923.field_41178.method_10221(item).toString()).toList();
                apply.accept(sherds);
            }
        });
    }

    private class_3222 getPlayer(GeyserSession session) {
        return this.server.method_3760().method_14602(session.getPlayerEntity().uuid());
    }
}

