/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.level.block.type;

import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.SkullCache;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.definitions.BlockDefinition;

public class SkullBlock
extends Block {
    private final Type type;

    public SkullBlock(String javaIdentifier, Type type, Block.Builder builder) {
        super(javaIdentifier, builder);
        this.type = type;
    }

    @Override
    protected void sendBlockUpdatePacket(GeyserSession session, BlockState state, BlockDefinition definition, Vector3i position) {
        SkullCache.Skull skull;
        if (this.type == Type.PLAYER && (skull = session.getSkullCache().updateSkull(position, state)) != null && skull.getBlockDefinition() != null) {
            definition = skull.getBlockDefinition();
        }
        super.sendBlockUpdatePacket(session, state, definition, position);
    }

    @Override
    protected void checkForEmptySkull(GeyserSession session, BlockState state, Vector3i position) {
    }

    public Type skullType() {
        return this.type;
    }

    public static enum Type {
        SKELETON(0),
        WITHER_SKELETON(1),
        PLAYER(3),
        ZOMBIE(2),
        CREEPER(4),
        PIGLIN(6),
        DRAGON(5);

        private final int bedrockId;

        private Type(int bedrockId) {
            this.bedrockId = bedrockId;
        }

        public int bedrockId() {
            return this.bedrockId;
        }
    }
}

