/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.type;

import org.geysermc.geyser.item.type.BlockItem;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.registry.type.ItemMappings;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.definitions.ItemDefinition;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.BlockStateProperties;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;

public class LightItem
extends BlockItem {
    public LightItem(Item.Builder builder, Block block, Block ... otherBlocks) {
        super(builder, block, otherBlocks);
    }

    @Override
    public ItemData.Builder translateToBedrock(GeyserSession session, int count, DataComponents components, ItemMapping mapping, ItemMappings mappings) {
        ItemMapping lightLevelMapping = LightItem.getLightLevelMapping(components, mappings);
        if (lightLevelMapping != null) {
            return super.translateToBedrock(session, count, components, lightLevelMapping, mappings);
        }
        return super.translateToBedrock(session, count, components, mapping, mappings);
    }

    @Override
    public ItemMapping toBedrockDefinition(DataComponents components, ItemMappings mappings) {
        ItemMapping lightLevelMapping = LightItem.getLightLevelMapping(components, mappings);
        if (lightLevelMapping != null) {
            return lightLevelMapping;
        }
        return super.toBedrockDefinition(components, mappings);
    }

    private static ItemMapping getLightLevelMapping(DataComponents components, ItemMappings mappings) {
        ItemDefinition definition;
        BlockStateProperties blockStateProperties;
        String lightLevel = "15";
        if (components != null && (blockStateProperties = components.get(DataComponentTypes.BLOCK_STATE)) != null) {
            lightLevel = blockStateProperties.getProperties().get(Properties.LEVEL.name());
        }
        if ((definition = mappings.getDefinition("minecraft:light_block_" + lightLevel)) != null) {
            return (ItemMapping)mappings.getLightBlocks().get(definition.getRuntimeId());
        }
        return null;
    }
}

