/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.custom.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.index.qual.Positive;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.api.item.custom.v2.component.java.JavaTool;
import org.geysermc.geyser.api.util.Holders;

public record JavaToolImpl(List<@NonNull JavaTool.Rule> rules, float defaultMiningSpeed, boolean canDestroyBlocksInCreative) implements JavaTool
{

    public record RuleImpl(Holders blocks, float speed) implements JavaTool.Rule
    {

        public static class Builder
        implements JavaTool.Rule.Builder {
            private Holders holders;
            private float speed;

            @Override
            public JavaTool.Rule.Builder blocks(@NonNull Holders blocks) {
                Objects.requireNonNull(blocks, "holders cannot be null");
                this.holders = blocks;
                return this;
            }

            @Override
            public JavaTool.Rule.Builder speed(@Positive float speed) {
                if (speed <= 0.0f) {
                    throw new IllegalArgumentException("speed must be above 0");
                }
                this.speed = speed;
                return this;
            }

            @Override
            public JavaTool.Rule build() {
                Objects.requireNonNull(this.holders, "holders cannot be null");
                if (this.speed <= 0.0f) {
                    throw new IllegalArgumentException("speed must be above 0");
                }
                return new RuleImpl(this.holders, this.speed);
            }
        }
    }

    public static class Builder
    implements JavaTool.Builder {
        private final List<JavaTool.Rule> rules = new ArrayList<JavaTool.Rule>();
        private float defaultMiningSpeed;
        private boolean destroyBlocksInCreative = true;

        @Override
        public JavaTool.Builder rule(@NonNull JavaTool.Rule rule) {
            Objects.requireNonNull(rule, "rule cannot be null");
            if (this.rules.contains(rule)) {
                throw new IllegalArgumentException("duplicate rule " + String.valueOf(rule));
            }
            this.rules.add(rule);
            return this;
        }

        @Override
        public JavaTool.Builder defaultMiningSpeed(float defaultMiningSpeed) {
            if (defaultMiningSpeed <= 0.0f) {
                throw new IllegalArgumentException("default mining speed must be above 0");
            }
            this.defaultMiningSpeed = defaultMiningSpeed;
            return this;
        }

        @Override
        public JavaTool.Builder canDestroyBlocksInCreative(boolean destroyBlocksInCreative) {
            this.destroyBlocksInCreative = destroyBlocksInCreative;
            return this;
        }

        @Override
        public JavaTool build() {
            return new JavaToolImpl(this.rules, this.defaultMiningSpeed, this.destroyBlocksInCreative);
        }
    }
}

