/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.custom;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.api.item.custom.v2.component.ItemDataComponent;
import org.geysermc.geyser.api.item.custom.v2.component.ItemDataComponentMap;
import org.geysermc.geyser.api.item.custom.v2.component.java.JavaConsumable;
import org.geysermc.geyser.api.item.custom.v2.component.java.JavaEquippable;
import org.geysermc.geyser.api.item.custom.v2.component.java.JavaItemDataComponents;
import org.geysermc.geyser.api.item.custom.v2.component.java.JavaKineticWeapon;
import org.geysermc.geyser.api.item.custom.v2.component.java.JavaRepairable;
import org.geysermc.geyser.api.item.custom.v2.component.java.JavaTool;
import org.geysermc.geyser.api.util.Identifier;
import org.geysermc.geyser.item.components.resolvable.ResolvableComponent;
import org.geysermc.geyser.item.components.resolvable.ResolvableRepairable;
import org.geysermc.geyser.item.components.resolvable.ResolvableToolProperties;
import org.geysermc.geyser.item.exception.InvalidItemComponentsException;
import org.geysermc.geyser.util.MinecraftKey;
import org.geysermc.mcprotocollib.protocol.data.game.entity.EquipmentSlot;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.AttackRange;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.Consumable;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentType;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.Equippable;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.FoodProperties;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.KineticWeapon;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.PiercingWeapon;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.SwingAnimation;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.ToolData;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.UseCooldown;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.UseEffects;
import org.geysermc.mcprotocollib.protocol.data.game.level.sound.BuiltinSound;

public class ComponentConverters {
    private static final Map<ItemDataComponent<?>, ResolvableComponentConverter<?>> converters = new HashMap();

    private static <T> void registerConverter(ItemDataComponent<T> component, DataComponentType<T> converted) {
        ComponentConverters.registerConverter(component, (DataComponents itemMap, T value) -> itemMap.put(converted, value));
    }

    private static <T> void registerConverter(ItemDataComponent<T> component, ComponentConverter<T> converter) {
        ComponentConverters.registerConverter(component, (DataComponents itemMap, T value, Consumer<ResolvableComponent<?>> resolvableConsumer) -> converter.convertAndPut(itemMap, value));
    }

    private static <T> void registerConverter(ItemDataComponent<T> component, ResolvableComponentConverter<T> converter) {
        converters.put(component, converter);
    }

    public static DataComponents convertComponentPatch(ItemDataComponentMap customDefinitionPatch, List<Identifier> customDefinitionRemovals, Consumer<ResolvableComponent<?>> resolvableConsumer) throws InvalidItemComponentsException {
        DataComponents converted = new DataComponents(new HashMap());
        for (ItemDataComponent<?> component : customDefinitionPatch.keySet()) {
            if (customDefinitionRemovals.contains(component.identifier())) {
                throw new InvalidItemComponentsException("Component " + String.valueOf(component.identifier()) + " was present both in the components to add and the components to remove");
            }
            ResolvableComponentConverter<?> converter = converters.get(component);
            if (converter == null) continue;
            Object value = customDefinitionPatch.get(component);
            converter.convert(converted, value, resolvableConsumer);
        }
        for (Identifier removed : customDefinitionRemovals) {
            DataComponentType<?> component = DataComponentTypes.fromKey(MinecraftKey.identifierToKey(removed));
            if (component == null) continue;
            converted.put(component, null);
        }
        return converted;
    }

    private static KineticWeapon.Condition convertKineticWeaponCondition(@Nullable JavaKineticWeapon.Condition condition) {
        if (condition == null) {
            return null;
        }
        return new KineticWeapon.Condition(condition.maxDurationTicks(), condition.minSpeed(), condition.minRelativeSpeed());
    }

    static {
        ComponentConverters.registerConverter(JavaItemDataComponents.CONSUMABLE, (DataComponents itemMap, T value) -> {
            Consumable.ItemUseAnimation convertedAnimation = switch (value.animation()) {
                default -> throw new IncompatibleClassChangeError();
                case JavaConsumable.Animation.NONE -> Consumable.ItemUseAnimation.NONE;
                case JavaConsumable.Animation.EAT -> Consumable.ItemUseAnimation.EAT;
                case JavaConsumable.Animation.DRINK -> Consumable.ItemUseAnimation.DRINK;
                case JavaConsumable.Animation.BLOCK -> Consumable.ItemUseAnimation.BLOCK;
                case JavaConsumable.Animation.BOW -> Consumable.ItemUseAnimation.BOW;
                case JavaConsumable.Animation.SPEAR -> Consumable.ItemUseAnimation.SPEAR;
                case JavaConsumable.Animation.CROSSBOW -> Consumable.ItemUseAnimation.CROSSBOW;
                case JavaConsumable.Animation.SPYGLASS -> Consumable.ItemUseAnimation.SPYGLASS;
                case JavaConsumable.Animation.BRUSH -> Consumable.ItemUseAnimation.BRUSH;
            };
            itemMap.put(DataComponentTypes.CONSUMABLE, new Consumable(value.consumeSeconds(), convertedAnimation, BuiltinSound.ENTITY_GENERIC_EAT, true, List.of()));
        });
        ComponentConverters.registerConverter(JavaItemDataComponents.EQUIPPABLE, (DataComponents itemMap, T value) -> {
            EquipmentSlot convertedSlot = switch (value.slot()) {
                default -> throw new IncompatibleClassChangeError();
                case JavaEquippable.EquipmentSlot.HEAD -> EquipmentSlot.HELMET;
                case JavaEquippable.EquipmentSlot.CHEST -> EquipmentSlot.CHESTPLATE;
                case JavaEquippable.EquipmentSlot.LEGS -> EquipmentSlot.LEGGINGS;
                case JavaEquippable.EquipmentSlot.FEET -> EquipmentSlot.BOOTS;
                case JavaEquippable.EquipmentSlot.BODY -> EquipmentSlot.BODY;
                case JavaEquippable.EquipmentSlot.SADDLE -> EquipmentSlot.SADDLE;
            };
            itemMap.put(DataComponentTypes.EQUIPPABLE, new Equippable(convertedSlot, BuiltinSound.ITEM_ARMOR_EQUIP_GENERIC, null, null, null, false, false, false, false, false, null));
        });
        ComponentConverters.registerConverter(JavaItemDataComponents.FOOD, (DataComponents itemMap, T value) -> itemMap.put(DataComponentTypes.FOOD, new FoodProperties(value.nutrition(), value.saturation(), value.canAlwaysEat())));
        ComponentConverters.registerConverter(JavaItemDataComponents.MAX_DAMAGE, DataComponentTypes.MAX_DAMAGE);
        ComponentConverters.registerConverter(JavaItemDataComponents.MAX_STACK_SIZE, DataComponentTypes.MAX_STACK_SIZE);
        ComponentConverters.registerConverter(JavaItemDataComponents.USE_COOLDOWN, (DataComponents itemMap, T value) -> itemMap.put(DataComponentTypes.USE_COOLDOWN, new UseCooldown(value.seconds(), MinecraftKey.identifierToKey(value.cooldownGroup()))));
        ComponentConverters.registerConverter(JavaItemDataComponents.ENCHANTABLE, DataComponentTypes.ENCHANTABLE);
        ComponentConverters.registerConverter(JavaItemDataComponents.TOOL, (DataComponents itemMap, T value, Consumer<ResolvableComponent<?>> consumer) -> {
            itemMap.put(DataComponentTypes.TOOL, new ToolData(List.of(), 1.0f, 1, value.canDestroyBlocksInCreative()));
            consumer.accept(new ResolvableToolProperties((JavaTool)value));
        });
        ComponentConverters.registerConverter(JavaItemDataComponents.REPAIRABLE, (DataComponents itemMap, T value, Consumer<ResolvableComponent<?>> consumer) -> consumer.accept(new ResolvableRepairable((JavaRepairable)value)));
        ComponentConverters.registerConverter(JavaItemDataComponents.ENCHANTMENT_GLINT_OVERRIDE, DataComponentTypes.ENCHANTMENT_GLINT_OVERRIDE);
        ComponentConverters.registerConverter(JavaItemDataComponents.ATTACK_RANGE, (DataComponents itemMap, T value) -> itemMap.put(DataComponentTypes.ATTACK_RANGE, new AttackRange(value.minReach(), value.maxReach(), value.minCreativeReach(), value.maxCreativeReach(), value.hitboxMargin(), 1.0f)));
        ComponentConverters.registerConverter(JavaItemDataComponents.KINETIC_WEAPON, (DataComponents itemMap, T value) -> itemMap.put(DataComponentTypes.KINETIC_WEAPON, new KineticWeapon(0, value.delayTicks(), ComponentConverters.convertKineticWeaponCondition(value.dismountConditions()), null, null, 0.0f, 1.0f, null, null)));
        ComponentConverters.registerConverter(JavaItemDataComponents.PIERCING_WEAPON, (DataComponents itemMap, T value) -> itemMap.put(DataComponentTypes.PIERCING_WEAPON, new PiercingWeapon(false, false, null, null)));
        ComponentConverters.registerConverter(JavaItemDataComponents.SWING_ANIMATION, (DataComponents itemMap, T value) -> itemMap.put(DataComponentTypes.SWING_ANIMATION, new SwingAnimation(SwingAnimation.Type.WHACK, value.duration())));
        ComponentConverters.registerConverter(JavaItemDataComponents.USE_EFFECTS, (DataComponents itemMap, T value) -> itemMap.put(DataComponentTypes.USE_EFFECTS, new UseEffects(false, true, value.speedMultiplier())));
    }

    @FunctionalInterface
    public static interface ComponentConverter<T> {
        public void convertAndPut(DataComponents var1, T var2);
    }

    @FunctionalInterface
    public static interface ResolvableComponentConverter<T> {
        public void convert(DataComponents var1, T var2, Consumer<ResolvableComponent<?>> var3);
    }
}

