/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.animal.tameable;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.living.animal.tameable.TameableEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.session.cache.tags.ItemTag;
import org.geysermc.geyser.session.cache.tags.Tag;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.InteractiveTag;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;

public class ParrotEntity
extends TameableEntity {
    public ParrotEntity(EntitySpawnContext context) {
        super(context);
    }

    @Override
    protected @Nullable Tag<Item> getFoodTag() {
        return null;
    }

    private boolean isTameFood(GeyserItemStack item) {
        return item.is(this.session, ItemTag.PARROT_FOOD);
    }

    private boolean isPoisonousFood(GeyserItemStack item) {
        return item.is(this.session, ItemTag.PARROT_POISONOUS_FOOD);
    }

    @Override
    protected @NonNull InteractiveTag testMobInteraction(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        boolean tame = this.getFlag(EntityFlag.TAMED);
        if (!tame && this.isTameFood(itemInHand)) {
            return InteractiveTag.FEED;
        }
        if (this.isPoisonousFood(itemInHand)) {
            return InteractiveTag.FEED;
        }
        if (this.onGround && tame && this.ownerBedrockId == this.session.getPlayerEntity().geyserId()) {
            return this.getFlag(EntityFlag.SITTING) ? InteractiveTag.STAND : InteractiveTag.SIT;
        }
        return super.testMobInteraction(hand, itemInHand);
    }

    @Override
    protected @NonNull InteractionResult mobInteract(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        boolean tame = this.getFlag(EntityFlag.TAMED);
        if (!tame && this.isTameFood(itemInHand)) {
            return InteractionResult.SUCCESS;
        }
        if (this.isPoisonousFood(itemInHand)) {
            return InteractionResult.SUCCESS;
        }
        if (this.onGround && tame && this.ownerBedrockId == this.session.getPlayerEntity().geyserId()) {
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(hand, itemInHand);
    }
}

