/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.animal.farm;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.living.animal.TemperatureVariantAnimal;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.session.cache.registry.JavaRegistries;
import org.geysermc.geyser.session.cache.registry.JavaRegistryKey;
import org.geysermc.geyser.session.cache.tags.ItemTag;
import org.geysermc.geyser.session.cache.tags.Tag;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.SoundEvent;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.InteractiveTag;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;

public class CowEntity
extends TemperatureVariantAnimal {
    public CowEntity(EntitySpawnContext context) {
        super(context);
    }

    @Override
    protected @NonNull InteractiveTag testMobInteraction(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        if (this.getFlag(EntityFlag.BABY) || !itemInHand.is(Items.BUCKET)) {
            return super.testMobInteraction(hand, itemInHand);
        }
        return InteractiveTag.MILK;
    }

    @Override
    protected @NonNull InteractionResult mobInteract(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        if (this.getFlag(EntityFlag.BABY) || !itemInHand.is(Items.BUCKET)) {
            return super.mobInteract(hand, itemInHand);
        }
        this.session.playSoundEvent(SoundEvent.MILK, this.position);
        return InteractionResult.SUCCESS;
    }

    @Override
    protected @Nullable Tag<Item> getFoodTag() {
        return ItemTag.COW_FOOD;
    }

    @Override
    public JavaRegistryKey<TemperatureVariantAnimal.BuiltInVariant> variantRegistry() {
        return JavaRegistries.COW_VARIANT;
    }
}

